/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.adapters.dnslookup;

import com.google.common.base.Splitter;
import com.google.common.net.HostAndPort;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.SequentialDnsServerAddressStreamProvider;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsNameResolverFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DnsNameResolverFactory.class);
    private static final int DEFAULT_DNS_PORT = 53;
    private final NioEventLoopGroup eventLoopGroup;
    private String dnsServerIps;
    private final long queryTimeout;

    public DnsNameResolverFactory(NioEventLoopGroup eventLoopGroup, String dnsServerIps, long queryTimeout) {
        this.eventLoopGroup = eventLoopGroup;
        this.dnsServerIps = dnsServerIps;
        this.queryTimeout = queryTimeout;
    }

    public DnsNameResolver create() {
        List<InetSocketAddress> iNetDnsServerIps = this.parseServerIpAddresses(this.dnsServerIps);
        DnsNameResolverBuilder dnsNameResolverBuilder = new DnsNameResolverBuilder(this.eventLoopGroup.next());
        dnsNameResolverBuilder.channelType(NioDatagramChannel.class).queryTimeoutMillis(this.queryTimeout);
        if (CollectionUtils.isNotEmpty(iNetDnsServerIps)) {
            LOG.debug("Attempting to start DNS client with server IPs [{}] on port [{}].", (Object)this.dnsServerIps, (Object)53);
            SequentialDnsServerAddressStreamProvider dnsServer = new SequentialDnsServerAddressStreamProvider(iNetDnsServerIps);
            dnsNameResolverBuilder.nameServerProvider((DnsServerAddressStreamProvider)dnsServer);
        } else {
            LOG.debug("Attempting to start DNS client with custom server IPs [{}] on port [{}].", (Object)this.dnsServerIps, (Object)53);
        }
        return dnsNameResolverBuilder.build();
    }

    private List<InetSocketAddress> parseServerIpAddresses(String dnsServerIps) {
        return StreamSupport.stream(Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)dnsServerIps).spliterator(), false).map(hostAndPort -> HostAndPort.fromString((String)hostAndPort).withDefaultPort(53)).map(hostAndPort -> new InetSocketAddress(hostAndPort.getHost(), hostAndPort.getPort())).collect(Collectors.toList());
    }
}

