/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.telemetry.rest.TelemetryService;
import org.graylog2.telemetry.rest.TelemetryUserSettings;

@RequiresAuthentication
@Api(value="Telemetry", description="Message inputs", tags={"cloud"})
@Path(value="/telemetry")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class TelemetryResource
extends RestResource {
    private final TelemetryService telemetryService;
    private final AuditEventSender auditEventSender;

    @Inject
    protected TelemetryResource(TelemetryService telemetryService, AuditEventSender auditEventSender) {
        this.telemetryService = telemetryService;
        this.auditEventSender = auditEventSender;
    }

    @GET
    @ApiOperation(value="Get telemetry information.")
    public Map<String, Object> get() {
        return this.telemetryService.getTelemetryResponse(this.getCurrentUserOrThrow());
    }

    @GET
    @Path(value="user/settings")
    @ApiOperation(value="Retrieve a user's telemetry settings.")
    @ApiResponses(value={@ApiResponse(code=404, message="Current user not found.")})
    public TelemetryUserSettings getTelemetryUserSettings() {
        return this.telemetryService.getTelemetryUserSettings(this.getCurrentUserOrThrow());
    }

    @PUT
    @Path(value="user/settings")
    @ApiOperation(value="Update a user's telemetry settings.")
    @ApiResponses(value={@ApiResponse(code=404, message="Current user not found.")})
    @NoAuditEvent(value="Audit event is sent manually.")
    public void saveTelemetryUserSettings(@ApiParam(name="JSON body", value="The telemetry settings to assign to the user.", required=true) @Valid @NotNull TelemetryUserSettings telemetryUserSettings) {
        User currentUser = this.getCurrentUserOrThrow();
        this.telemetryService.saveUserSettings(currentUser, telemetryUserSettings);
        this.auditEventSender.success(AuditActor.user(currentUser.getName()), "server:telemetry_user_settings:update", Map.of("telemetry_enabled", telemetryUserSettings.telemetryEnabled(), "telemetry_permission_asked", telemetryUserSettings.telemetryPermissionAsked()));
    }

    private User getCurrentUserOrThrow() {
        User currentUser = this.getCurrentUser();
        if (currentUser == null) {
            throw new NotFoundException("Couldn't find current user!");
        }
        return currentUser;
    }
}

