/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.search;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.events.processor.EventProcessorException;
import org.graylog.events.search.AutoValue_MoreSearch_Result;
import org.graylog.events.search.EventsSearchParameters;
import org.graylog.events.search.MoreSearchAdapter;
import org.graylog.plugins.views.search.IndexRangeContainsOneOfStreams;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.elasticsearch.QueryStringDecorators;
import org.graylog.plugins.views.search.errors.EmptyParameterError;
import org.graylog.plugins.views.search.errors.SearchException;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreSearch {
    private static final Logger LOG = LoggerFactory.getLogger(MoreSearch.class);
    private final StreamService streamService;
    private final IndexRangeService indexRangeService;
    private final QueryStringDecorators esQueryDecorators;
    private final MoreSearchAdapter moreSearchAdapter;

    @Inject
    public MoreSearch(StreamService streamService, IndexRangeService indexRangeService, QueryStringDecorators esQueryDecorators, MoreSearchAdapter moreSearchAdapter) {
        this.streamService = streamService;
        this.indexRangeService = indexRangeService;
        this.esQueryDecorators = esQueryDecorators;
        this.moreSearchAdapter = moreSearchAdapter;
    }

    Result eventSearch(EventsSearchParameters parameters, String filterString, Set<String> eventStreams, Set<String> forbiddenSourceStreams) {
        Preconditions.checkArgument((parameters != null ? 1 : 0) != 0, (Object)"parameters cannot be null");
        Preconditions.checkArgument((!eventStreams.isEmpty() ? 1 : 0) != 0, (Object)"eventStreams cannot be empty");
        Preconditions.checkArgument((forbiddenSourceStreams != null ? 1 : 0) != 0, (Object)"forbiddenSourceStreams cannot be null");
        Sorting.Direction sortDirection = parameters.sortDirection() == EventsSearchParameters.SortDirection.ASC ? Sorting.Direction.ASC : Sorting.Direction.DESC;
        Sorting sorting = new Sorting(parameters.sortBy(), sortDirection);
        String queryString = parameters.query().trim();
        Set<String> affectedIndices = this.getAffectedIndices(eventStreams, parameters.timerange());
        return this.moreSearchAdapter.eventSearch(queryString, parameters.timerange(), affectedIndices, sorting, parameters.page(), parameters.perPage(), eventStreams, filterString, forbiddenSourceStreams);
    }

    private Set<String> getAffectedIndices(Set<String> streamIds, TimeRange timeRange) {
        SortedSet<IndexRange> indexRanges = this.indexRangeService.find(timeRange.getFrom(), timeRange.getTo());
        if (streamIds.isEmpty()) {
            return indexRanges.stream().map(IndexRange::indexName).collect(Collectors.toSet());
        }
        Set<Stream> streams = this.loadStreams(streamIds);
        IndexRangeContainsOneOfStreams indexRangeContainsOneOfStreams = new IndexRangeContainsOneOfStreams();
        return indexRanges.stream().filter(ir -> indexRangeContainsOneOfStreams.test((IndexRange)ir, streams)).map(IndexRange::indexName).collect(Collectors.toSet());
    }

    public void scrollQuery(String queryString, Set<String> streams, Set<Parameter> queryParameters, TimeRange timeRange, int batchSize, ScrollCallback resultCallback) throws EventProcessorException {
        Set<String> affectedIndices = this.getAffectedIndices(streams, timeRange);
        try {
            queryString = this.decorateQuery(queryParameters, timeRange, queryString);
        }
        catch (SearchException e) {
            if (e.error() instanceof EmptyParameterError) {
                LOG.debug("Empty parameter from lookup table. Assuming non-matching query. Error: {}", (Object)e.getMessage());
                return;
            }
            throw e;
        }
        this.moreSearchAdapter.scrollEvents(queryString, timeRange, affectedIndices, streams, batchSize, resultCallback::call);
    }

    public Set<Stream> loadStreams(Set<String> streamIds) {
        HashSet<Stream> streams = new HashSet<Stream>();
        for (String streamId : streamIds) {
            try {
                Stream load = this.streamService.load(streamId);
                streams.add(load);
            }
            catch (NotFoundException e) {
                LOG.debug("Failed to load stream <{}>", (Object)streamId);
            }
        }
        return streams;
    }

    private String decorateQuery(Set<Parameter> queryParameters, TimeRange timeRange, String queryString) {
        Search search = Search.builder().parameters((ImmutableSet<Parameter>)ImmutableSet.copyOf(queryParameters)).build();
        SearchJob searchJob = new SearchJob("1234", search, "events backend");
        Query dummyQuery = Query.builder().id("123").timerange(timeRange).query(ElasticsearchQueryString.of(queryString)).build();
        return this.esQueryDecorators.decorate(queryString, searchJob, dummyQuery);
    }

    public static String luceneEscape(String searchString) {
        StringBuilder result = new StringBuilder();
        if (searchString != null) {
            for (char c : searchString.toCharArray()) {
                if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == '/') {
                    result.append('\\');
                }
                result.append(c);
            }
        }
        return result.toString();
    }

    @AutoValue
    public static abstract class Result {
        public abstract List<ResultMessage> results();

        public abstract long resultsCount();

        public abstract long duration();

        public abstract Set<String> usedIndexNames();

        public abstract String executedQuery();

        public static Builder builder() {
            return new AutoValue_MoreSearch_Result.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder results(List<ResultMessage> var1);

            public abstract Builder resultsCount(long var1);

            public abstract Builder duration(long var1);

            public abstract Builder usedIndexNames(Set<String> var1);

            public abstract Builder executedQuery(String var1);

            public abstract Result build();
        }
    }

    public static interface ScrollCallback {
        public void call(List<ResultMessage> var1, AtomicBoolean var2) throws EventProcessorException;
    }
}

