/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes.pivot.buckets;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.FieldsSortingComparator;

public class ValuesBucketOrdering {
    private static boolean isGroupingSort(SortSpec sort) {
        return "pivot".equals(sort.type());
    }

    private static boolean hasGroupingSort(List<SortSpec> sorts) {
        return sorts.stream().anyMatch(ValuesBucketOrdering::isGroupingSort);
    }

    private static boolean needsReorderingFields(List<String> fields, List<SortSpec> sorts) {
        return fields.size() >= 2 && !sorts.isEmpty() && ValuesBucketOrdering.hasGroupingSort(sorts);
    }

    public static List<String> orderFields(List<String> fields, List<SortSpec> sorts) {
        if (!ValuesBucketOrdering.needsReorderingFields(fields, sorts)) {
            return fields;
        }
        List<String> sortFields = sorts.stream().filter(ValuesBucketOrdering::isGroupingSort).map(SortSpec::field).collect(Collectors.toList());
        return fields.stream().sorted(new FieldsSortingComparator(sortFields)).collect(Collectors.toList());
    }

    public static Function<List<String>, List<String>> reorderFieldsFunction(List<String> fields, List<SortSpec> sorts) {
        if (!ValuesBucketOrdering.needsReorderingFields(fields, sorts)) {
            return Function.identity();
        }
        List<String> orderedBuckets = ValuesBucketOrdering.orderFields(fields, sorts);
        Map mapping = IntStream.range(0, fields.size()).boxed().collect(Collectors.toMap(Function.identity(), i -> orderedBuckets.indexOf(fields.get((int)i))));
        return keys -> IntStream.range(0, fields.size()).boxed().map(i -> (String)keys.get((Integer)mapping.get(i))).collect(Collectors.toList());
    }
}

