/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.graylog.security.certutil.console.CommandLineConsole;
import org.graylog.security.certutil.console.ConsoleException;

public class SystemConsole
implements CommandLineConsole {
    @Override
    public String readLine(String format, Object ... args) {
        if (System.console() != null) {
            return System.console().readLine(format, args);
        }
        this.printLine(String.format(Locale.ROOT, format, args));
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            throw new ConsoleException(e);
        }
    }

    @Override
    public char[] readPassword(String format, Object ... args) {
        if (System.console() != null) {
            return System.console().readPassword(format, args);
        }
        return this.readLine(format, args).toCharArray();
    }

    @Override
    public void printLine(String line) {
        System.out.println(line);
    }
}

