/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Locale;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.lifecycles.LoadBalancerStatus;
import org.graylog2.rest.TooManyRequestsStatus;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="System/LoadBalancers", description="Status propagation for load balancers")
@Path(value="/system/lbstatus")
public class LoadBalancerStatusResource
extends RestResource {
    private final ServerStatus serverStatus;

    @Inject
    public LoadBalancerStatusResource(ServerStatus serverStatus) {
        this.serverStatus = serverStatus;
    }

    @GET
    @Timed
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get status of this Graylog server node for load balancers. Returns ALIVE with HTTP 200, DEAD with HTTP 503, or THROTTLED with HTTP 429.")
    public Response status() {
        LoadBalancerStatus lbStatus = this.serverStatus.getLifecycle().getLoadbalancerStatus();
        return Response.status((Response.StatusType)(switch (lbStatus) {
            case LoadBalancerStatus.ALIVE -> Response.Status.OK;
            case LoadBalancerStatus.THROTTLED -> new TooManyRequestsStatus();
            default -> Response.Status.SERVICE_UNAVAILABLE;
        })).entity((Object)lbStatus.toString().toUpperCase(Locale.ENGLISH)).build();
    }

    @PUT
    @Timed
    @RequiresAuthentication
    @RequiresPermissions(value={"lbstatus:change"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Override load balancer status of this Graylog server node. Next lifecycle change will override it again to its default. Set to ALIVE, DEAD, or THROTTLED.")
    @Path(value="/override/{status}")
    @AuditEvent(type="server:load_balancer_status:update")
    public void override(@ApiParam(name="status") @PathParam(value="status") String status) {
        LoadBalancerStatus lbStatus;
        try {
            lbStatus = LoadBalancerStatus.valueOf(status.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException((Throwable)e);
        }
        switch (lbStatus) {
            case DEAD: {
                this.serverStatus.overrideLoadBalancerDead();
                break;
            }
            case ALIVE: {
                this.serverStatus.overrideLoadBalancerAlive();
                break;
            }
            case THROTTLED: {
                this.serverStatus.overrideLoadBalancerThrottled();
            }
        }
    }
}

