/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.processors.instancelookup;

import com.codahale.metrics.MetricRegistry;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import okhttp3.HttpUrl;
import org.graylog.aws.auth.AWSAuthProvider;
import org.graylog.aws.config.AWSPluginConfiguration;
import org.graylog.aws.migrations.V20200505121200_EncryptAWSSecretKey;
import org.graylog.aws.processors.instancelookup.InstanceLookupTable;
import org.graylog2.Configuration;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Messages;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.messageprocessors.MessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSInstanceNameLookupProcessor
implements MessageProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AWSInstanceNameLookupProcessor.class);
    private static final ImmutableList<String> TRANSLATABLE_FIELD_NAMES = ImmutableList.builder().add((Object)"src_addr").add((Object)"dst_addr").build();
    private final MetricRegistry metricRegistry;
    private final InstanceLookupTable table;
    private AWSPluginConfiguration config;

    @Inject
    public AWSInstanceNameLookupProcessor(final ClusterConfigService clusterConfigService, InstanceLookupTable instanceLookupTable, MetricRegistry metricRegistry, final Configuration configuration) {
        this.metricRegistry = metricRegistry;
        this.table = instanceLookupTable;
        Runnable refresh = new Runnable(){

            @Override
            public void run() {
                try {
                    AWSInstanceNameLookupProcessor.this.waitForMigrationCompletion(clusterConfigService);
                    AWSInstanceNameLookupProcessor.this.config = clusterConfigService.getOrDefault(AWSPluginConfiguration.class, AWSPluginConfiguration.createDefault());
                    if (!AWSInstanceNameLookupProcessor.this.config.lookupsEnabled()) {
                        LOG.debug("AWS instance name lookups are disabled.");
                        return;
                    }
                    if (AWSInstanceNameLookupProcessor.this.config.lookupsEnabled() && AWSInstanceNameLookupProcessor.this.config.getLookupRegions().isEmpty()) {
                        LOG.warn("AWS region configuration is not complete. No instance lookups will happen.");
                        return;
                    }
                    AWSAuthProvider awsAuthProvider = new AWSAuthProvider(configuration, AWSInstanceNameLookupProcessor.this.config);
                    LOG.debug("Refreshing AWS instance lookup table.");
                    HttpUrl proxyUrl = AWSInstanceNameLookupProcessor.this.config.proxyEnabled() && configuration.getHttpProxyUri() != null ? HttpUrl.get((URI)configuration.getHttpProxyUri()) : null;
                    AWSInstanceNameLookupProcessor.this.table.reload(AWSInstanceNameLookupProcessor.this.config.getLookupRegions(), awsAuthProvider, proxyUrl);
                }
                catch (Exception e) {
                    LOG.error("Could not refresh AWS instance lookup table.", (Throwable)e);
                }
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("aws-instance-lookup-refresher-%d").setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.error("Uncaught exception in AWS instance lookup refresher.", e);
            }
        }).build());
        executor.scheduleWithFixedDelay(refresh, 0L, 60L, TimeUnit.SECONDS);
    }

    private void waitForMigrationCompletion(ClusterConfigService clusterConfigService) throws ExecutionException, RetryException {
        Retryer waitingForMigrationCompletion = RetryerBuilder.newBuilder().retryIfResult(result -> result == null || result == false).build();
        waitingForMigrationCompletion.call(() -> clusterConfigService.get(V20200505121200_EncryptAWSSecretKey.MigrationCompleted.class) != null);
    }

    @Override
    public Messages process(Messages messages) {
        if (this.config == null || !this.config.lookupsEnabled() || !this.table.isLoaded()) {
            return messages;
        }
        for (Message message : messages) {
            Object awsGroupId = message.getField("aws_source");
            if (awsGroupId == null || !awsGroupId.equals(true)) continue;
            TRANSLATABLE_FIELD_NAMES.stream().filter(fieldName -> message.hasField((String)fieldName)).forEach(fieldName -> {
                message.addField(fieldName + "_entity", this.table.findByIp(message.getField((String)fieldName).toString()).getName());
                message.addField(fieldName + "_entity_description", this.table.findByIp(message.getField((String)fieldName).toString()).getDescription());
                message.addField(fieldName + "_entity_aws_type", this.table.findByIp(message.getField((String)fieldName).toString()).getAWSType());
            });
        }
        return messages;
    }

    public static class Descriptor
    implements MessageProcessor.Descriptor {
        @Override
        public String name() {
            return "AWS Instance Name Lookup";
        }

        @Override
        public String className() {
            return AWSInstanceNameLookupProcessor.class.getCanonicalName();
        }
    }
}

