/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.enterprise;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.enterprise.EnterpriseService;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Enterprise")
@Path(value="/enterprise")
@Produces(value={"application/json"})
@RequiresAuthentication
public class EnterpriseResource
extends RestResource {
    private final EnterpriseService enterpriseService;

    @Inject
    public EnterpriseResource(EnterpriseService enterpriseService) {
        this.enterpriseService = enterpriseService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get Graylog Enterprise license info")
    @Path(value="/license/info")
    @RequiresPermissions(value={"licenseinfos:read"})
    public Response licenseInfo() {
        return Response.ok(Collections.singletonMap("license_info", this.enterpriseService.licenseInfo())).build();
    }
}

