/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.events.event.AutoValue_EventDto;
import org.graylog.events.event.ESMongoDateTimeDeserializer;
import org.graylog.events.event.EventReplayInfo;
import org.joda.time.DateTime;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EventDto {
    public static final String FIELD_ID = "id";
    public static final String FIELD_EVENT_DEFINITION_TYPE = "event_definition_type";
    public static final String FIELD_EVENT_DEFINITION_ID = "event_definition_id";
    private static final String FIELD_ORIGIN_CONTEXT = "origin_context";
    public static final String FIELD_EVENT_TIMESTAMP = "timestamp";
    public static final String FIELD_PROCESSING_TIMESTAMP = "timestamp_processing";
    public static final String FIELD_TIMERANGE_START = "timerange_start";
    public static final String FIELD_TIMERANGE_END = "timerange_end";
    public static final String FIELD_STREAMS = "streams";
    public static final String FIELD_SOURCE_STREAMS = "source_streams";
    public static final String FIELD_ALERT = "alert";
    public static final String FIELD_MESSAGE = "message";
    private static final String FIELD_SOURCE = "source";
    private static final String FIELD_KEY_TUPLE = "key_tuple";
    private static final String FIELD_KEY = "key";
    private static final String FIELD_PRIORITY = "priority";
    private static final String FIELD_FIELDS = "fields";
    private static final String FIELD_GROUP_BY_FIELDS = "group_by_fields";
    private static final String FIELD_REPLAY_INFO = "replay_info";

    @JsonProperty(value="id")
    public abstract String id();

    @JsonProperty(value="event_definition_type")
    public abstract String eventDefinitionType();

    @JsonProperty(value="event_definition_id")
    public abstract String eventDefinitionId();

    @JsonProperty(value="origin_context")
    public abstract Optional<String> originContext();

    @JsonProperty(value="timestamp")
    public abstract DateTime eventTimestamp();

    @JsonProperty(value="timestamp_processing")
    public abstract DateTime processingTimestamp();

    @JsonProperty(value="timerange_start")
    public abstract Optional<DateTime> timerangeStart();

    @JsonProperty(value="timerange_end")
    public abstract Optional<DateTime> timerangeEnd();

    @JsonProperty(value="streams")
    public abstract Set<String> streams();

    @JsonProperty(value="source_streams")
    public abstract Set<String> sourceStreams();

    @JsonProperty(value="message")
    public abstract String message();

    @JsonProperty(value="source")
    public abstract String source();

    @JsonProperty(value="key_tuple")
    public abstract List<String> keyTuple();

    @JsonProperty(value="key")
    @Nullable
    public abstract String key();

    @JsonProperty(value="priority")
    public abstract long priority();

    @JsonProperty(value="alert")
    public abstract boolean alert();

    @JsonProperty(value="fields")
    public abstract Map<String, String> fields();

    @JsonProperty(value="group_by_fields")
    public abstract Map<String, String> groupByFields();

    @JsonProperty(value="replay_info")
    public abstract Optional<EventReplayInfo> replayInfo();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @JsonIgnoreProperties(value={"_id"})
    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_EventDto.Builder().sourceStreams((Set<String>)ImmutableSet.of()).groupByFields((Map<String, String>)ImmutableMap.of());
        }

        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="event_definition_type")
        public abstract Builder eventDefinitionType(String var1);

        @JsonProperty(value="event_definition_id")
        public abstract Builder eventDefinitionId(String var1);

        @JsonProperty(value="origin_context")
        public abstract Builder originContext(@Nullable String var1);

        @JsonProperty(value="timestamp")
        @JsonDeserialize(using=ESMongoDateTimeDeserializer.class)
        public abstract Builder eventTimestamp(DateTime var1);

        @JsonProperty(value="timestamp_processing")
        @JsonDeserialize(using=ESMongoDateTimeDeserializer.class)
        public abstract Builder processingTimestamp(DateTime var1);

        @JsonProperty(value="timerange_start")
        @JsonDeserialize(using=ESMongoDateTimeDeserializer.class)
        public abstract Builder timerangeStart(@Nullable DateTime var1);

        @JsonProperty(value="timerange_end")
        @JsonDeserialize(using=ESMongoDateTimeDeserializer.class)
        public abstract Builder timerangeEnd(@Nullable DateTime var1);

        @JsonProperty(value="streams")
        public abstract Builder streams(Set<String> var1);

        @JsonProperty(value="source_streams")
        public abstract Builder sourceStreams(Set<String> var1);

        @JsonProperty(value="message")
        public abstract Builder message(String var1);

        @JsonProperty(value="source")
        public abstract Builder source(String var1);

        @JsonProperty(value="key_tuple")
        public abstract Builder keyTuple(List<String> var1);

        @JsonProperty(value="key")
        public abstract Builder key(@Nullable String var1);

        @JsonProperty(value="priority")
        public abstract Builder priority(long var1);

        @JsonProperty(value="alert")
        public abstract Builder alert(boolean var1);

        @JsonProperty(value="fields")
        public abstract Builder fields(Map<String, String> var1);

        @JsonProperty(value="group_by_fields")
        public abstract Builder groupByFields(Map<String, String> var1);

        @JsonProperty(value="replay_info")
        public abstract Builder replayInfo(@Nullable EventReplayInfo var1);

        public abstract EventDto build();
    }
}

