/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.event;

import com.codahale.metrics.Meter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.graylog.events.event.Event;
import org.graylog.events.event.EventDto;
import org.graylog.events.event.EventReplayInfo;
import org.graylog.events.fields.FieldValue;
import org.graylog2.jackson.TypeReferences;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class EventImpl
implements Event {
    private final String eventId;
    private final String eventDefinitionType;
    private final String eventDefinitionId;
    private String originContext;
    private DateTime eventTimestamp;
    private DateTime processingTimestamp;
    private DateTime timerangeStart;
    private DateTime timerangeEnd;
    private ImmutableSet<String> streams = ImmutableSet.of();
    private ImmutableSet<String> sourceStreams = ImmutableSet.of();
    private String message;
    private String source;
    private ImmutableList<String> keyTuple = ImmutableList.of();
    private long priority;
    private boolean alert;
    private Map<String, FieldValue> fields = new HashMap<String, FieldValue>();
    private Map<String, FieldValue> groupByFields = new HashMap<String, FieldValue>();
    private EventReplayInfo replayInfo;

    EventImpl(String eventId, DateTime eventTimestamp, String eventDefinitionType, String eventDefinitionId, String message, String source, long priority, boolean alert) {
        this.eventId = eventId;
        this.eventTimestamp = eventTimestamp;
        this.processingTimestamp = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        this.eventDefinitionType = eventDefinitionType;
        this.eventDefinitionId = eventDefinitionId;
        this.priority = priority;
        this.alert = alert;
        this.message = message;
        this.source = source;
    }

    @Override
    public String getId() {
        return this.eventId;
    }

    @Override
    public String getMessageId() {
        return this.eventId;
    }

    @Override
    public String getEventDefinitionType() {
        return this.eventDefinitionType;
    }

    @Override
    public String getEventDefinitionId() {
        return this.eventDefinitionId;
    }

    @Override
    public String getOriginContext() {
        return this.originContext;
    }

    @Override
    public void setOriginContext(String originContext) {
        this.originContext = originContext;
    }

    @Override
    public DateTime getEventTimestamp() {
        return this.eventTimestamp;
    }

    @Override
    public DateTime getReceiveTime() {
        return this.getEventTimestamp();
    }

    @Override
    public DateTime getTimestamp() {
        return this.getEventTimestamp();
    }

    @Override
    public void setEventTimestamp(DateTime eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    @Override
    public DateTime getProcessingTimestamp() {
        return this.processingTimestamp;
    }

    @Override
    public void setProcessingTimestamp(DateTime processingTimestamp) {
        this.processingTimestamp = processingTimestamp;
    }

    @Override
    public DateTime getTimerangeStart() {
        return this.timerangeStart;
    }

    @Override
    public void setTimerangeStart(DateTime timerangeStart) {
        this.timerangeStart = timerangeStart;
    }

    @Override
    public DateTime getTimerangeEnd() {
        return this.timerangeEnd;
    }

    @Override
    public void setTimerangeEnd(DateTime timerangeEnd) {
        this.timerangeEnd = timerangeEnd;
    }

    @Override
    public ImmutableSet<String> getStreams() {
        return this.streams;
    }

    @Override
    public void addStream(String stream) {
        this.streams = ImmutableSet.builder().addAll(this.streams).add((Object)stream).build();
    }

    @Override
    public void removeStream(String stream) {
        this.streams = ImmutableSet.builder().addAll((Iterable)this.streams.stream().filter(s -> !s.equals(stream)).collect(Collectors.toSet())).build();
    }

    @Override
    public ImmutableSet<String> getSourceStreams() {
        return this.sourceStreams;
    }

    @Override
    public void addSourceStream(String sourceStream) {
        this.sourceStreams = ImmutableSet.builder().addAll(this.sourceStreams).add((Object)sourceStream).build();
    }

    @Override
    public void removeSourceStream(String sourceStream) {
        this.sourceStreams = ImmutableSet.builder().addAll((Iterable)this.sourceStreams.stream().filter(s -> !s.equals(sourceStream)).collect(Collectors.toSet())).build();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public ImmutableList<String> getKeyTuple() {
        return this.keyTuple;
    }

    @Override
    public void setKeyTuple(List<String> keyTuple) {
        this.keyTuple = ImmutableList.copyOf(keyTuple);
    }

    @Override
    public long getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(long priority) {
        this.priority = priority;
    }

    @Override
    public boolean getAlert() {
        return this.alert;
    }

    @Override
    public void setAlert(boolean alert) {
        this.alert = alert;
    }

    @Override
    public FieldValue getField(String name) {
        return this.fields.get(name);
    }

    @Override
    public void setField(String name, FieldValue value) {
        this.fields.put(name, value);
    }

    @Override
    public void setFields(Map<String, String> fields) {
        this.fields = fields.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> FieldValue.string((String)entry.getValue())));
    }

    @Override
    public boolean hasField(String name) {
        return this.fields.containsKey(name);
    }

    @Override
    public Map<String, String> getGroupByFields() {
        return this.groupByFields.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((FieldValue)e.getValue()).value()));
    }

    @Override
    public void setGroupByFields(Map<String, String> fields) {
        this.groupByFields = fields.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> FieldValue.string((String)entry.getValue())));
    }

    @Override
    public EventReplayInfo getReplayInfo() {
        return this.replayInfo;
    }

    @Override
    public void setReplayInfo(EventReplayInfo replayInfo) {
        this.replayInfo = replayInfo;
    }

    @Override
    public EventDto toDto() {
        Map<String, String> fields = this.fields.entrySet().stream().filter(entry -> !((FieldValue)entry.getValue()).isError()).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((FieldValue)entry.getValue()).value()));
        Map<String, String> groupByFields = this.groupByFields.entrySet().stream().filter(entry -> !((FieldValue)entry.getValue()).isError()).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((FieldValue)entry.getValue()).value()));
        return EventDto.builder().id(this.getId()).eventDefinitionType(this.getEventDefinitionType()).eventDefinitionId(this.getEventDefinitionId()).originContext(this.getOriginContext()).eventTimestamp(this.getEventTimestamp()).processingTimestamp(this.getProcessingTimestamp()).timerangeStart(this.getTimerangeStart()).timerangeEnd(this.getTimerangeEnd()).streams((Set<String>)this.getStreams()).sourceStreams((Set<String>)this.getSourceStreams()).message(this.getMessage()).source(this.getSource()).keyTuple((List<String>)this.getKeyTuple()).key(String.join((CharSequence)"|", this.getKeyTuple())).priority(this.getPriority()).alert(this.getAlert()).fields((Map<String, String>)ImmutableMap.copyOf(fields)).groupByFields((Map<String, String>)ImmutableMap.copyOf(groupByFields)).replayInfo(this.getReplayInfo()).build();
    }

    @Override
    public Map<String, Object> toElasticSearchObject(ObjectMapper objectMapper, @Nonnull Meter invalidTimestampMeter) {
        Map source = (Map)objectMapper.convertValue((Object)this.toDto(), TypeReferences.MAP_STRING_OBJECT);
        source.put("timestamp", Tools.buildElasticSearchTimeFormat(Objects.requireNonNull(this.getEventTimestamp()).withZone(DateTimeZone.UTC)));
        source.put("timestamp_processing", Tools.buildElasticSearchTimeFormat(Objects.requireNonNull(this.getProcessingTimestamp()).withZone(DateTimeZone.UTC)));
        if (this.getTimerangeStart() != null) {
            source.put("timerange_start", Tools.buildElasticSearchTimeFormat(this.getTimerangeStart().withZone(DateTimeZone.UTC)));
        }
        if (this.getTimerangeEnd() != null) {
            source.put("timerange_end", Tools.buildElasticSearchTimeFormat(this.getTimerangeEnd().withZone(DateTimeZone.UTC)));
        }
        if (this.getStreams().isEmpty()) {
            throw new IllegalStateException("Event streams cannot be empty");
        }
        return source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventImpl event = (EventImpl)o;
        return this.priority == event.priority && this.alert == event.alert && Objects.equals(this.eventId, event.eventId) && Objects.equals(this.eventDefinitionType, event.eventDefinitionType) && Objects.equals(this.eventDefinitionId, event.eventDefinitionId) && Objects.equals(this.originContext, event.originContext) && Objects.equals(this.eventTimestamp, event.eventTimestamp) && Objects.equals(this.processingTimestamp, event.processingTimestamp) && Objects.equals(this.timerangeStart, event.timerangeStart) && Objects.equals(this.timerangeEnd, event.timerangeEnd) && Objects.equals(this.streams, event.streams) && Objects.equals(this.sourceStreams, event.sourceStreams) && Objects.equals(this.message, event.message) && Objects.equals(this.source, event.source) && Objects.equals(this.keyTuple, event.keyTuple) && Objects.equals(this.fields, event.fields) && Objects.equals(this.groupByFields, event.groupByFields) && Objects.equals(this.replayInfo, event.replayInfo);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.eventDefinitionType, this.eventDefinitionId, this.originContext, this.eventTimestamp, this.processingTimestamp, this.timerangeStart, this.timerangeEnd, this.streams, this.sourceStreams, this.message, this.source, this.keyTuple, this.priority, this.alert, this.fields, this.groupByFields, this.replayInfo);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("eventId", (Object)this.eventId).add("eventDefinitionType", (Object)this.eventDefinitionType).add("eventDefinitionId", (Object)this.eventDefinitionId).add("originContext", (Object)this.originContext).add("eventTimestamp", (Object)this.eventTimestamp).add("processingTimestamp", (Object)this.processingTimestamp).add("timerangeStart", (Object)this.timerangeStart).add("timerangeEnd", (Object)this.timerangeEnd).add("streams", this.streams).add("sourceStreams", this.sourceStreams).add("message", (Object)this.message).add("source", (Object)this.source).add("keyTuple", this.keyTuple).add("priority", this.priority).add("alert", this.alert).add("fields", this.fields).add("groupByFields", this.groupByFields).add("replayInfo", (Object)this.replayInfo).toString();
    }

    @Override
    public long getSize() {
        return 0L;
    }
}

