/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.migrations;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20230629140000_RenameFieldTypeOfEventDefinitionSeries
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20230629140000_RenameFieldTypeOfEventDefinitionSeries.class);
    private static final String SERIES_PATH_STRING = "config.series";
    private final ClusterConfigService clusterConfigService;
    private final MongoCollection<Document> collection;

    @Inject
    public V20230629140000_RenameFieldTypeOfEventDefinitionSeries(ClusterConfigService clusterConfigService, MongoConnection mongoConnection) {
        this.clusterConfigService = clusterConfigService;
        this.collection = mongoConnection.getMongoDatabase().getCollection("event_definitions");
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-06-29T14:00:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        FindIterable result = this.collection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"config.type", (Object)"aggregation-v1"), Filters.type((String)SERIES_PATH_STRING, (String)"array"), Filters.exists((String)"config.series.0")}));
        ArrayList<ReplaceOneModel> bulkOperations = new ArrayList<ReplaceOneModel>();
        for (Document doc : result) {
            Document config = (Document)doc.get((Object)"config", Document.class);
            List series = config.getList((Object)"series", Document.class, Collections.emptyList());
            boolean needsUpdate = false;
            ArrayList<Document> newSeries = new ArrayList<Document>(series.size());
            for (Document s : series) {
                if (!s.containsKey((Object)"function")) {
                    newSeries.add(s);
                    continue;
                }
                needsUpdate = true;
                s.put("type", s.get((Object)"function"));
                s.remove((Object)"function");
                newSeries.add(s);
            }
            if (!needsUpdate) continue;
            config.put("series", newSeries);
            doc.put("config", (Object)config);
            bulkOperations.add(new ReplaceOneModel(Filters.eq((String)"_id", (Object)doc.getObjectId((Object)"_id")), (Object)doc, new ReplaceOptions().upsert(false)));
        }
        if (bulkOperations.size() > 0) {
            this.collection.bulkWrite(bulkOperations);
        }
        this.clusterConfigService.write(new MigrationCompleted());
    }

    public record MigrationCompleted() {
    }
}

