/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.events.processor.DBEventProcessorStateService;
import org.graylog.events.processor.EventProcessorStateDto;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.system.processing.DBProcessingStatusService;
import org.joda.time.DateTime;

public class EventProcessorDependencyCheck {
    private final DBEventProcessorStateService stateService;
    private final DBProcessingStatusService processingStatusService;

    @Inject
    public EventProcessorDependencyCheck(DBEventProcessorStateService stateService, DBProcessingStatusService processingStatusService) {
        this.stateService = stateService;
        this.processingStatusService = processingStatusService;
    }

    public boolean canProcessTimerange(DateTime maxTimestamp, Set<String> processorDependencies) {
        ImmutableSet foundIds = (ImmutableSet)this.stateService.findByEventDefinitionsAndMaxTimestamp(processorDependencies, maxTimestamp).stream().map(EventProcessorStateDto::eventDefinitionId).collect(ImmutableSet.toImmutableSet());
        return foundIds.containsAll(processorDependencies);
    }

    public boolean hasMessagesIndexedUpTo(TimeRange timeRange) {
        return DBProcessingStatusService.ProcessingNodesState.SOME_UP_TO_DATE == this.processingStatusService.calculateProcessingState(timeRange);
    }
}

