/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor;

import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.graylog.events.event.EventFactory;
import org.graylog.events.event.EventProcessorEventFactory;
import org.graylog.events.event.EventWithContext;
import org.graylog.events.fields.EventFieldSpec;
import org.graylog.events.fields.EventFieldSpecEngine;
import org.graylog.events.fields.FieldValue;
import org.graylog.events.notifications.EventNotificationHandler;
import org.graylog.events.processor.DBEventDefinitionService;
import org.graylog.events.processor.EventConsumer;
import org.graylog.events.processor.EventDefinition;
import org.graylog.events.processor.EventDefinitionHandler;
import org.graylog.events.processor.EventProcessor;
import org.graylog.events.processor.EventProcessorException;
import org.graylog.events.processor.EventProcessorExecutionMetrics;
import org.graylog.events.processor.EventProcessorParameters;
import org.graylog.events.processor.storage.EventStorageHandlerEngine;
import org.graylog.events.processor.storage.EventStorageHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EventProcessorEngine {
    private static final Logger LOG = LoggerFactory.getLogger(EventProcessorEngine.class);
    private final DBEventDefinitionService dbService;
    private final Map<String, ? extends EventProcessor.Factory> eventProcessorFactories;
    private final EventFieldSpecEngine fieldSpecEngine;
    private final EventNotificationHandler notificationHandler;
    private final EventStorageHandlerEngine storageHandlerEngine;
    private final Provider<EventProcessorEventFactory> eventFactoryProvider;
    private final EventProcessorExecutionMetrics metrics;
    private final EventDefinitionHandler eventDefinitionHandler;

    @Inject
    public EventProcessorEngine(Map<String, EventProcessor.Factory> eventProcessorFactories, DBEventDefinitionService dbService, EventFieldSpecEngine fieldSpecEngine, EventNotificationHandler notificationHandler, EventStorageHandlerEngine storageHandlerEngine, Provider<EventProcessorEventFactory> eventFactoryProvider, EventProcessorExecutionMetrics metrics, EventDefinitionHandler eventDefinitionHandler) {
        this.dbService = dbService;
        this.eventProcessorFactories = eventProcessorFactories;
        this.fieldSpecEngine = fieldSpecEngine;
        this.notificationHandler = notificationHandler;
        this.storageHandlerEngine = storageHandlerEngine;
        this.eventFactoryProvider = eventFactoryProvider;
        this.metrics = metrics;
        this.eventDefinitionHandler = eventDefinitionHandler;
    }

    private EventDefinition getEventDefinition(String id) throws EventProcessorException {
        return (EventDefinition)this.dbService.get(id).orElseThrow(() -> new EventProcessorException("Event definition <" + id + "> doesn't exist", true, id));
    }

    public void execute(String definitionId, EventProcessorParameters parameters) throws EventProcessorException {
        EventDefinition definition = this.getEventDefinition(definitionId);
        EventProcessor.Factory factory = this.eventProcessorFactories.get(definition.config().type());
        if (factory == null) {
            throw new EventProcessorException("Couldn't find event processor factory for type " + definition.config().type(), true, definitionId, definition);
        }
        LOG.debug("Executing event processor <{}/{}/{}>", new Object[]{definition.title(), definition.id(), definition.config().type()});
        Object eventProcessor = factory.create(definition);
        EventConsumer<List<EventWithContext>> eventConsumer = eventsWithContext -> this.emitEvents((EventProcessor)eventProcessor, definition, (List<EventWithContext>)eventsWithContext);
        this.metrics.registerEventProcessor((EventProcessor)eventProcessor, definitionId);
        try {
            this.metrics.recordExecutions((EventProcessor)eventProcessor, definitionId);
            Stopwatch stopwatch = Stopwatch.createStarted();
            eventProcessor.createEvents((EventFactory)this.eventFactoryProvider.get(), parameters, eventConsumer);
            stopwatch.stop();
            this.metrics.recordExecutionTime((EventProcessor)eventProcessor, definitionId, stopwatch.elapsed());
            this.metrics.recordSuccess((EventProcessor)eventProcessor, definitionId);
        }
        catch (EventProcessorException e) {
            this.metrics.recordException((EventProcessor)eventProcessor, definitionId);
            throw e;
        }
        catch (Exception e) {
            this.metrics.recordException((EventProcessor)eventProcessor, definitionId);
            LOG.error("Caught an unhandled exception while executing event processor <{}/{}/{}> - Make sure to modify the event processor to throw only EventProcessorException so we get more context!", new Object[]{definition.config().type(), definition.title(), definition.id(), e});
            throw new EventProcessorException("Couldn't create events for: " + definition.toString(), false, definition, e);
        }
    }

    private void emitEvents(EventProcessor eventProcessor, EventDefinition eventDefinition, List<EventWithContext> eventsWithContext) throws EventProcessorException {
        if (eventsWithContext.isEmpty()) {
            return;
        }
        this.metrics.recordCreatedEvents(eventProcessor, eventDefinition.id(), eventsWithContext.size());
        this.eventDefinitionHandler.updateLastMatched(eventsWithContext);
        try {
            this.fieldSpecEngine.execute(eventsWithContext, (Map<String, EventFieldSpec>)eventDefinition.fieldSpec());
            eventsWithContext.forEach(eventWithContext -> {
                List<String> keyTuple = eventDefinition.keySpec().stream().map(fieldName -> eventWithContext.event().getField((String)fieldName)).filter(Objects::nonNull).filter(fieldValue -> !fieldValue.isError()).map(FieldValue::value).collect(Collectors.toList());
                if (keyTuple.size() != eventDefinition.keySpec().size()) {
                    LOG.warn("Key spec <{}> for event <{}> cannot be fulfilled", eventDefinition.keySpec(), (Object)eventWithContext.event());
                }
                eventWithContext.event().setKeyTuple(keyTuple);
            });
            this.notificationHandler.handleEvents(eventDefinition, eventsWithContext);
            try {
                this.storageHandlerEngine.handleEvents(eventsWithContext, eventDefinition.storage());
            }
            catch (EventStorageHandlerException e) {
                throw new EventProcessorException("Failed to execute storage handlers", false, eventDefinition, e);
            }
        }
        catch (Exception e) {
            throw new EventProcessorException("Couldn't emit events for: " + eventDefinition.toString(), false, eventDefinition, e);
        }
    }
}

