/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.aggregation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.graylog.events.processor.aggregation.AggregationKeyResult;
import org.graylog.events.processor.aggregation.AggregationResult;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;

final class AutoValue_AggregationResult
extends AggregationResult {
    private final ImmutableList<AggregationKeyResult> keyResults;
    private final AbsoluteRange effectiveTimerange;
    private final long totalAggregatedMessages;
    private final Set<String> sourceStreams;

    private AutoValue_AggregationResult(ImmutableList<AggregationKeyResult> keyResults, AbsoluteRange effectiveTimerange, long totalAggregatedMessages, Set<String> sourceStreams) {
        this.keyResults = keyResults;
        this.effectiveTimerange = effectiveTimerange;
        this.totalAggregatedMessages = totalAggregatedMessages;
        this.sourceStreams = sourceStreams;
    }

    @Override
    public ImmutableList<AggregationKeyResult> keyResults() {
        return this.keyResults;
    }

    @Override
    public AbsoluteRange effectiveTimerange() {
        return this.effectiveTimerange;
    }

    @Override
    public long totalAggregatedMessages() {
        return this.totalAggregatedMessages;
    }

    @Override
    public Set<String> sourceStreams() {
        return this.sourceStreams;
    }

    public String toString() {
        return "AggregationResult{keyResults=" + this.keyResults + ", effectiveTimerange=" + this.effectiveTimerange + ", totalAggregatedMessages=" + this.totalAggregatedMessages + ", sourceStreams=" + this.sourceStreams + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AggregationResult) {
            AggregationResult that = (AggregationResult)o;
            return this.keyResults.equals(that.keyResults()) && this.effectiveTimerange.equals(that.effectiveTimerange()) && this.totalAggregatedMessages == that.totalAggregatedMessages() && this.sourceStreams.equals(that.sourceStreams());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.keyResults.hashCode();
        h$ *= 1000003;
        h$ ^= this.effectiveTimerange.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.totalAggregatedMessages >>> 32 ^ this.totalAggregatedMessages);
        h$ *= 1000003;
        return h$ ^= this.sourceStreams.hashCode();
    }

    @Override
    public AggregationResult.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AggregationResult.Builder {
        private ImmutableList<AggregationKeyResult> keyResults;
        private AbsoluteRange effectiveTimerange;
        private long totalAggregatedMessages;
        private Set<String> sourceStreams;
        private byte set$0;

        Builder() {
        }

        private Builder(AggregationResult source) {
            this.keyResults = source.keyResults();
            this.effectiveTimerange = source.effectiveTimerange();
            this.totalAggregatedMessages = source.totalAggregatedMessages();
            this.sourceStreams = source.sourceStreams();
            this.set$0 = 1;
        }

        @Override
        public AggregationResult.Builder keyResults(List<AggregationKeyResult> keyResults) {
            this.keyResults = ImmutableList.copyOf(keyResults);
            return this;
        }

        @Override
        public AggregationResult.Builder effectiveTimerange(AbsoluteRange effectiveTimerange) {
            if (effectiveTimerange == null) {
                throw new NullPointerException("Null effectiveTimerange");
            }
            this.effectiveTimerange = effectiveTimerange;
            return this;
        }

        @Override
        public AggregationResult.Builder totalAggregatedMessages(long totalAggregatedMessages) {
            this.totalAggregatedMessages = totalAggregatedMessages;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public AggregationResult.Builder sourceStreams(Set<String> sourceStreams) {
            if (sourceStreams == null) {
                throw new NullPointerException("Null sourceStreams");
            }
            this.sourceStreams = sourceStreams;
            return this;
        }

        @Override
        public AggregationResult build() {
            if (this.set$0 != 1 || this.keyResults == null || this.effectiveTimerange == null || this.sourceStreams == null) {
                StringBuilder missing = new StringBuilder();
                if (this.keyResults == null) {
                    missing.append(" keyResults");
                }
                if (this.effectiveTimerange == null) {
                    missing.append(" effectiveTimerange");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" totalAggregatedMessages");
                }
                if (this.sourceStreams == null) {
                    missing.append(" sourceStreams");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AggregationResult(this.keyResults, this.effectiveTimerange, this.totalAggregatedMessages, this.sourceStreams);
        }
    }
}

