/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.systemnotification;

import freemarker.cache.ConditionalTemplateConfigurationFactory;
import freemarker.cache.PathGlobMatcher;
import freemarker.cache.TemplateConfigurationFactory;
import freemarker.cache.TemplateSourceMatcher;
import freemarker.core.HTMLOutputFormat;
import freemarker.core.OutputFormat;
import freemarker.core.TemplateConfiguration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import org.graylog2.Configuration;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.shared.utilities.StringUtils;

public class SystemNotificationRenderService {
    private static final String KEY_NODE_ID = "node_id";
    private static final String KEY_TITLE = "_title";
    private static final String KEY_DESCRIPTION = "_description";
    private static final String KEY_CLOUD = "_cloud";
    public static final String TEMPLATE_BASE_PATH = "/org/graylog2/freemarker/templates/";
    private NotificationService notificationService;
    private Configuration graylogConfig;
    private static final freemarker.template.Configuration cfg = new freemarker.template.Configuration(freemarker.template.Configuration.VERSION_2_3_28);

    @Inject
    public SystemNotificationRenderService(NotificationService notificationService, Configuration graylogConfig) {
        this.notificationService = notificationService;
        this.graylogConfig = graylogConfig;
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setClassForTemplateLoading(SystemNotificationRenderService.class, TEMPLATE_BASE_PATH);
        TemplateConfiguration tcHTML = new TemplateConfiguration();
        tcHTML.setOutputFormat((OutputFormat)HTMLOutputFormat.INSTANCE);
        cfg.setTemplateConfigurations((TemplateConfigurationFactory)new ConditionalTemplateConfigurationFactory((TemplateSourceMatcher)new PathGlobMatcher(Format.HTML.name() + "/**"), tcHTML));
    }

    public RenderResponse render(Notification.Type type, String key, Format format, Map<String, Object> values) {
        Notification notification = this.notificationService.getByTypeAndKey(type, key).orElseThrow(() -> new NotFoundException(StringUtils.f("Event type <%s/%s> is not currently active", new Object[]{type, key})));
        return this.render(notification, format, values);
    }

    public RenderResponse render(Notification notification) {
        return this.render(notification, Format.PLAINTEXT, null);
    }

    public RenderResponse render(Notification notification, Format format, Map<String, Object> values) {
        RenderResponse renderResponse;
        if (values == null) {
            values = new HashMap<String, Object>();
        }
        if (notification.getDetails() != null) {
            values.putAll(notification.getDetails());
        }
        if (notification.getNodeId() != null) {
            values.put(KEY_NODE_ID, notification.getNodeId());
        }
        values.put(KEY_CLOUD, this.graylogConfig.isCloud());
        String templateRelPath = format.toString() + "/" + notification.getType().toString().toLowerCase(Locale.ENGLISH) + ".ftl";
        StringWriter writer = new StringWriter();
        try {
            Template template = cfg.getTemplate(templateRelPath);
            values.put(KEY_TITLE, true);
            values.put(KEY_DESCRIPTION, false);
            template.process(values, (Writer)writer);
            String title = writer.toString();
            writer.getBuffer().setLength(0);
            values.put(KEY_TITLE, false);
            values.put(KEY_DESCRIPTION, true);
            template.process(values, (Writer)writer);
            String description = writer.toString();
            renderResponse = new RenderResponse(title, description);
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TemplateException e) {
                throw new BadRequestException("Unable to render template " + notification.getType().toString() + ": " + e.getMessage());
            }
            catch (IOException e) {
                throw new BadRequestException("Unable to locate template " + notification.getType().toString() + ": " + e.getMessage());
            }
        }
        writer.close();
        return renderResponse;
    }

    public static enum Format {
        HTML,
        PLAINTEXT;

    }

    public class RenderResponse {
        public String title;
        public String description;

        public RenderResponse(String title, String description) {
            this.title = title;
            this.description = description;
        }
    }
}

