/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.failure;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.graylog.failure.Failure;
import org.graylog.failure.IndexingFailure;
import org.graylog.failure.ProcessingFailure;

public class FailureBatch {
    private final List<? extends Failure> failures;
    private final Class<? extends Failure> failureClass;

    private FailureBatch(List<? extends Failure> failures, Class<? extends Failure> failureClass) {
        this.failures = ImmutableList.copyOf(failures);
        this.failureClass = failureClass;
        this.failures.forEach(f -> {
            if (!f.getClass().equals(failureClass)) {
                throw new IllegalArgumentException("Not all failures from the list are instances of " + failureClass.getName());
            }
        });
    }

    public static FailureBatch indexingFailureBatch(List<IndexingFailure> indexingFailures) {
        return new FailureBatch(indexingFailures, IndexingFailure.class);
    }

    public static FailureBatch processingFailureBatch(List<ProcessingFailure> processingFailures) {
        return new FailureBatch(processingFailures, ProcessingFailure.class);
    }

    public static FailureBatch processingFailureBatch(ProcessingFailure processingFailure) {
        return FailureBatch.processingFailureBatch((List<ProcessingFailure>)ImmutableList.of((Object)processingFailure));
    }

    public List<? extends Failure> getFailures() {
        return this.failures;
    }

    public int size() {
        return this.failures.size();
    }

    public Class<? extends Failure> getFailureClass() {
        return this.failureClass;
    }

    public boolean containsIndexingFailures() {
        return this.getFailureClass().equals(IndexingFailure.class);
    }

    public boolean containsProcessingFailures() {
        return this.getFailureClass().equals(ProcessingFailure.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailureBatch that = (FailureBatch)o;
        return Objects.equal(this.failures, that.failures) && Objects.equal(this.failureClass, that.failureClass);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.failures, this.failureClass});
    }
}

