/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.aws.resources;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.integrations.aws.resources.requests.AWSInputCreateRequest;
import org.graylog.integrations.aws.resources.requests.AWSRequestImpl;
import org.graylog.integrations.aws.resources.requests.KinesisHealthCheckRequest;
import org.graylog.integrations.aws.resources.responses.AvailableServiceResponse;
import org.graylog.integrations.aws.resources.responses.KinesisHealthCheckResponse;
import org.graylog.integrations.aws.resources.responses.KinesisPermissionsResponse;
import org.graylog.integrations.aws.resources.responses.LogGroupsResponse;
import org.graylog.integrations.aws.resources.responses.RegionsResponse;
import org.graylog.integrations.aws.resources.responses.StreamsResponse;
import org.graylog.integrations.aws.service.AWSService;
import org.graylog.integrations.aws.service.CloudWatchService;
import org.graylog.integrations.aws.service.KinesisService;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.inputs.Input;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.rest.resources.system.inputs.AbstractInputsResource;
import org.graylog2.shared.inputs.MessageInputFactory;

@Api(value="AWS", description="AWS integrations")
@Path(value="/aws")
@RequiresAuthentication
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AWSResource
extends AbstractInputsResource
implements PluginRestResource {
    private final AWSService awsService;
    private final KinesisService kinesisService;
    private final CloudWatchService cloudWatchService;

    @Inject
    public AWSResource(AWSService awsService, KinesisService kinesisService, CloudWatchService cloudWatchService, MessageInputFactory messageInputFactory) {
        super(messageInputFactory.getAvailableInputs());
        this.awsService = awsService;
        this.kinesisService = kinesisService;
        this.cloudWatchService = cloudWatchService;
    }

    @GET
    @Timed
    @Path(value="/regions")
    @ApiOperation(value="Get all available AWS regions")
    @RequiresPermissions(value={"aws:read"})
    public RegionsResponse getAwsRegions() {
        return this.awsService.getAvailableRegions();
    }

    @GET
    @Timed
    @Path(value="/available_services")
    @ApiResponses(value={@ApiResponse(code=500, message="An error occurred encoding the policy JSON")})
    @ApiOperation(value="Get all available AWS services")
    @RequiresPermissions(value={"aws:read"})
    public AvailableServiceResponse getAvailableServices() {
        return this.awsService.getAvailableServices();
    }

    @GET
    @Timed
    @Path(value="/permissions")
    @ApiResponses(value={@ApiResponse(code=500, message="An error occurred encoding the policy JSON")})
    @ApiOperation(value="Get the permissions required for the AWS Kinesis setup and for the Kinesis auto-setup.")
    @RequiresPermissions(value={"aws:read"})
    public KinesisPermissionsResponse getPermissions() {
        return this.awsService.getPermissions();
    }

    @POST
    @Timed
    @Path(value="/cloudwatch/log_groups")
    @ApiOperation(value="Get all available AWS CloudWatch log groups names for the specified region.")
    @RequiresPermissions(value={"aws:read"})
    @NoAuditEvent(value="This does not change any data")
    public LogGroupsResponse getLogGroupNames(@ApiParam(name="JSON body", required=true) @Valid @NotNull AWSRequestImpl request) {
        return this.cloudWatchService.getLogGroupNames(request);
    }

    @POST
    @Timed
    @Path(value="/kinesis/streams")
    @ApiOperation(value="Get all available Kinesis streams for the specified region.")
    @RequiresPermissions(value={"aws:read"})
    @NoAuditEvent(value="This does not change any data")
    public StreamsResponse getKinesisStreams(@ApiParam(name="JSON body", required=true) @Valid @NotNull AWSRequestImpl request) throws ExecutionException {
        return this.kinesisService.getKinesisStreamNames(request);
    }

    @POST
    @Timed
    @Path(value="/kinesis/health_check")
    @ApiOperation(value="Attempt to retrieve logs from the indicated AWS log group with the specified credentials.", response=KinesisHealthCheckResponse.class)
    @RequiresPermissions(value={"aws:read"})
    @NoAuditEvent(value="This does not change any data")
    public Response kinesisHealthCheck(@ApiParam(name="JSON body", required=true) @Valid @NotNull KinesisHealthCheckRequest heathCheckRequest) throws ExecutionException, IOException {
        KinesisHealthCheckResponse response = this.kinesisService.healthCheck(heathCheckRequest);
        return Response.accepted().entity((Object)response).build();
    }

    @POST
    @Timed
    @Path(value="/inputs")
    @ApiOperation(value="Create a new AWS input.")
    @RequiresPermissions(value={"inputs:create"})
    @AuditEvent(type="integrations:kinesis_input:create")
    public Response create(@ApiParam(name="JSON body", required=true) @Valid @NotNull AWSInputCreateRequest saveRequest) throws Exception {
        Input input = this.awsService.saveInput(saveRequest, this.getCurrentUser());
        return Response.ok().entity((Object)this.getInputSummary(input)).build();
    }
}

