/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.inputs.paloalto;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.integrations.inputs.paloalto.PaloAltoMessageBase;
import org.graylog.integrations.inputs.paloalto.PaloAltoParser;
import org.graylog.integrations.inputs.paloalto.PaloAltoTemplateDefaults;
import org.graylog.integrations.inputs.paloalto.PaloAltoTemplates;
import org.graylog.integrations.inputs.paloalto.PaloAltoTypeParser;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.DropdownField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.journal.RawMessage;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaloAltoCodec
implements Codec {
    public static final String NAME = "PaloAlto";
    public static final String CK_TRAFFIC_TEMPLATE = "TRAFFIC_TEMPLATE";
    public static final String CK_THREAT_TEMPLATE = "THREAT_TEMPLATE";
    public static final String CK_SYSTEM_TEMPLATE = "SYSTEM_TEMPLATE";
    public static final String CK_TIMEZONE = "TIMEZONE";
    private static final Logger LOG = LoggerFactory.getLogger(PaloAltoCodec.class);
    private final Configuration configuration;
    private final PaloAltoParser parser;
    private final PaloAltoTemplates templates;

    @AssistedInject
    public PaloAltoCodec(@Assisted Configuration configuration) {
        this.configuration = configuration;
        this.parser = new PaloAltoParser();
        this.templates = PaloAltoTemplates.newInstance(configuration.getString(CK_SYSTEM_TEMPLATE, PaloAltoTemplateDefaults.SYSTEM_TEMPLATE), configuration.getString(CK_THREAT_TEMPLATE, PaloAltoTemplateDefaults.THREAT_TEMPLATE), configuration.getString(CK_TRAFFIC_TEMPLATE, PaloAltoTemplateDefaults.TRAFFIC_TEMPLATE));
    }

    @Override
    @Nullable
    public Message decode(@Nonnull RawMessage rawMessage) {
        String s = new String(rawMessage.getPayload(), StandardCharsets.UTF_8);
        LOG.trace("Received raw message: {}", (Object)s);
        String timezoneID = this.configuration.getString(CK_TIMEZONE);
        DateTimeZone timezone = timezoneID != null ? DateTimeZone.forID((String)timezoneID) : DateTimeZone.UTC;
        LOG.trace("Configured time zone: {}", (Object)timezone);
        PaloAltoMessageBase p = this.parser.parse(s, timezone);
        if (p == null) {
            return null;
        }
        Message message = new Message(p.payload(), p.source(), p.timestamp());
        switch (p.panType()) {
            case "THREAT": {
                PaloAltoTypeParser parserThreat = new PaloAltoTypeParser(this.templates.getThreatMessageTemplate());
                message.addFields((Map<String, Object>)parserThreat.parseFields((List<String>)p.fields(), timezone));
                break;
            }
            case "SYSTEM": {
                PaloAltoTypeParser parserSystem = new PaloAltoTypeParser(this.templates.getSystemMessageTemplate());
                message.addFields((Map<String, Object>)parserSystem.parseFields((List<String>)p.fields(), timezone));
                break;
            }
            case "TRAFFIC": {
                PaloAltoTypeParser parserTraffic = new PaloAltoTypeParser(this.templates.getTrafficMessageTemplate());
                message.addFields((Map<String, Object>)parserTraffic.parseFields((List<String>)p.fields(), timezone));
                break;
            }
            default: {
                LOG.error("Unsupported PAN type [{}]. Not adding any parsed fields.", (Object)p.panType());
            }
        }
        LOG.trace("Successfully processed [{}] message with [{}] fields.", (Object)p.panType(), (Object)message.getFieldCount());
        return message;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    @Nonnull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    @Nullable
    public CodecAggregator getAggregator() {
        return null;
    }

    @ConfigClass
    public static class Config
    implements Codec.Config {
        private static final String SYSTEM_MESSAGE_LABEL = "System Message Mappings";
        private static final String THREAT_MESSAGE_LABEL = "Threat Message Mappings";
        private static final String TRAFFIC_MESSAGE_LABEL = "Traffic Message Mappings";
        private static final String TIMEZONE_OFFSET_LABEL = "Time Zone";
        private static final String SYSTEM_MESSAGE_DESCRIPTION = "CSV string representing the fields/positions/data types to parse. (See documentation)";
        private static final String THREAT_MESSAGE_DESCRIPTION = "CSV string representing the fields/positions/data types to parse. (See documentation)";
        private static final String TRAFFIC_MESSAGE_DESCRIPTION = "CSV representing the fields/positions/data types to parse. (See documentation)";
        private static final String TIMEZONE_OFFSET_DESCRIPTION = "Time zone of the Palo Alto device";

        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest request = new ConfigurationRequest();
            request.addField(new DropdownField(PaloAltoCodec.CK_TIMEZONE, TIMEZONE_OFFSET_LABEL, DateTimeZone.UTC.getID(), DropdownField.ValueTemplates.timeZones(), TIMEZONE_OFFSET_DESCRIPTION, ConfigurationField.Optional.OPTIONAL));
            request.addField(new TextField(PaloAltoCodec.CK_SYSTEM_TEMPLATE, SYSTEM_MESSAGE_LABEL, PaloAltoTemplateDefaults.SYSTEM_TEMPLATE, "CSV string representing the fields/positions/data types to parse. (See documentation)", ConfigurationField.Optional.OPTIONAL, TextField.Attribute.TEXTAREA));
            request.addField(new TextField(PaloAltoCodec.CK_THREAT_TEMPLATE, THREAT_MESSAGE_LABEL, PaloAltoTemplateDefaults.THREAT_TEMPLATE, "CSV string representing the fields/positions/data types to parse. (See documentation)", ConfigurationField.Optional.OPTIONAL, TextField.Attribute.TEXTAREA));
            request.addField(new TextField(PaloAltoCodec.CK_TRAFFIC_TEMPLATE, TRAFFIC_MESSAGE_LABEL, PaloAltoTemplateDefaults.TRAFFIC_TEMPLATE, TRAFFIC_MESSAGE_DESCRIPTION, ConfigurationField.Optional.OPTIONAL, TextField.Attribute.TEXTAREA));
            return request;
        }

        @Override
        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<PaloAltoCodec> {
        @Override
        public PaloAltoCodec create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

