/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.inputs.paloalto;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.assistedinject.Assisted;
import javax.inject.Inject;
import org.graylog.integrations.inputs.paloalto.PaloAltoCodec;
import org.graylog.integrations.inputs.paloalto.PaloAltoTemplateDefaults;
import org.graylog.integrations.inputs.paloalto.PaloAltoTemplates;
import org.graylog2.inputs.transports.SyslogTcpTransport;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.buffers.InputBuffer;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.MisfireException;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaloAltoTCPInput
extends MessageInput {
    public static final String NAME = "Palo Alto Networks TCP (PAN-OS v8.x)";
    private static final Logger LOG = LoggerFactory.getLogger(PaloAltoTCPInput.class);

    @Inject
    public PaloAltoTCPInput(@Assisted Configuration configuration, MetricRegistry metricRegistry, SyslogTcpTransport.Factory transport, LocalMetricRegistry localRegistry, PaloAltoCodec.Factory codec, Config config, Descriptor descriptor, ServerStatus serverStatus) {
        super(metricRegistry, configuration, transport.create(configuration), localRegistry, codec.create(configuration), config, descriptor, serverStatus);
    }

    @Override
    public void launch(InputBuffer buffer) throws MisfireException {
        PaloAltoTemplates templates = PaloAltoTemplates.newInstance(this.configuration.getString("SYSTEM_TEMPLATE", PaloAltoTemplateDefaults.SYSTEM_TEMPLATE), this.configuration.getString("THREAT_TEMPLATE", PaloAltoTemplateDefaults.THREAT_TEMPLATE), this.configuration.getString("TRAFFIC_TEMPLATE", PaloAltoTemplateDefaults.TRAFFIC_TEMPLATE));
        if (templates.hasErrors()) {
            throw new MisfireException(templates.errorMessageSummary("\n"));
        }
        super.launch(buffer);
    }

    @ConfigClass
    public static class Config
    extends MessageInput.Config {
        @Inject
        public Config(SyslogTcpTransport.Factory transport, PaloAltoCodec.Factory codec) {
            super(transport.getConfig(), codec.getConfig());
        }
    }

    public static class Descriptor
    extends MessageInput.Descriptor {
        public Descriptor() {
            super(PaloAltoTCPInput.NAME, false, "");
        }
    }

    @FactoryClass
    public static interface Factory
    extends MessageInput.Factory<PaloAltoTCPInput> {
        @Override
        public PaloAltoTCPInput create(Configuration var1);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

