/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.inputs.paloalto;

import java.io.FileWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class PaloAltoUtils {
    private PaloAltoUtils() {
    }

    public static void dataParserTest() throws Exception {
        List<Object> hexVals = new ArrayList<String>();
        Object buffer = "";
        for (String textLine : PaloAltoUtils.getTextLines()) {
            if (!textLine.equals("")) {
                buffer = (String)buffer + textLine;
                continue;
            }
            hexVals.add(buffer);
            buffer = "";
        }
        hexVals = hexVals.stream().map(s -> s.replace(" ", "")).map(h -> {
            byte[] bytes = new byte[]{};
            try {
                bytes = Hex.decodeHex((char[])h.toCharArray());
            }
            catch (DecoderException e) {
                e.printStackTrace();
            }
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return "";
            }
        }).filter(s -> s.contains("- - - -")).filter(s -> s.contains(">1")).filter(s -> s.contains("<")).map(s -> s.substring(s.indexOf(">1") - 3, s.length())).collect(Collectors.toList());
        FileWriter writer = new FileWriter("capture-clean.txt", StandardCharsets.UTF_8);
        for (String string : hexVals) {
            writer.write(string + "\n");
        }
        writer.close();
    }

    private static List<String> getTextLines() throws Exception {
        String s = new String(Files.readAllBytes(Paths.get("capture", new String[0])), StandardCharsets.UTF_8);
        return Arrays.asList(s.replace("\t", "").split("\\n")).stream().map(v -> {
            String withoutPrefix;
            String string = withoutPrefix = v.length() > 7 ? v.substring(7, v.length()) : v;
            if (withoutPrefix.length() > 32) {
                withoutPrefix = withoutPrefix.substring(0, 39);
            }
            return withoutPrefix;
        }).collect(Collectors.toList());
    }
}

