/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.inputs.paloalto9;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.integrations.inputs.paloalto.PaloAltoMessageBase;
import org.graylog.integrations.inputs.paloalto.PaloAltoMessageType;
import org.graylog.integrations.inputs.paloalto.PaloAltoParser;
import org.graylog.integrations.inputs.paloalto9.PaloAlto9xParser;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.DropdownField;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.journal.RawMessage;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaloAlto9xCodec
implements Codec {
    private static final Logger LOG = LoggerFactory.getLogger(PaloAlto9xCodec.class);
    static final String CK_STORE_FULL_MESSAGE = "store_full_message";
    static final String CK_TIMEZONE = "timezone";
    public static final String NAME = "PaloAlto9x";
    private final Configuration configuration;
    private final PaloAltoParser rawMessageParser;
    private final PaloAlto9xParser fieldProducer;
    private final DateTimeZone timezone;

    @AssistedInject
    public PaloAlto9xCodec(@Assisted Configuration configuration, PaloAltoParser rawMessageParser, PaloAlto9xParser fieldProducer) {
        this.configuration = configuration;
        String timezoneID = configuration.getString(CK_TIMEZONE);
        this.timezone = timezoneID != null ? DateTimeZone.forID((String)timezoneID) : DateTimeZone.UTC;
        LOG.trace("Configured with time zone: {}", (Object)this.timezone);
        this.rawMessageParser = rawMessageParser;
        this.fieldProducer = fieldProducer;
    }

    @Override
    @Nullable
    public Message decode(@Nonnull RawMessage rawMessage) {
        String s = new String(rawMessage.getPayload(), StandardCharsets.UTF_8);
        LOG.trace("Received raw message: {}", (Object)s);
        PaloAltoMessageBase p = this.rawMessageParser.parse(s, this.timezone);
        if (p == null) {
            return null;
        }
        Message message = new Message(p.payload(), p.source(), p.timestamp());
        switch (p.panType()) {
            case "THREAT": {
                message.addFields((Map<String, Object>)this.fieldProducer.parseFields(PaloAltoMessageType.THREAT, (List<String>)p.fields(), this.timezone));
                break;
            }
            case "SYSTEM": {
                message.addFields((Map<String, Object>)this.fieldProducer.parseFields(PaloAltoMessageType.SYSTEM, (List<String>)p.fields(), this.timezone));
                break;
            }
            case "TRAFFIC": {
                message.addFields((Map<String, Object>)this.fieldProducer.parseFields(PaloAltoMessageType.TRAFFIC, (List<String>)p.fields(), this.timezone));
                break;
            }
            case "CONFIG": {
                message.addFields((Map<String, Object>)this.fieldProducer.parseFields(PaloAltoMessageType.CONFIG, (List<String>)p.fields(), this.timezone));
                break;
            }
            case "HIP-MATCH": 
            case "HIPMATCH": {
                message.addFields((Map<String, Object>)this.fieldProducer.parseFields(PaloAltoMessageType.HIP, (List<String>)p.fields(), this.timezone));
                break;
            }
            case "CORRELATION": {
                message.addFields((Map<String, Object>)this.fieldProducer.parseFields(PaloAltoMessageType.CORRELATION, (List<String>)p.fields(), this.timezone));
                break;
            }
            case "GLOBALPROTECT": {
                message.addFields((Map<String, Object>)this.fieldProducer.parseFields(PaloAltoMessageType.GLOBAL_PROTECT_9_1_3, (List<String>)p.fields(), this.timezone));
                break;
            }
            case "USERID": {
                message.addFields((Map<String, Object>)this.fieldProducer.parseFields(PaloAltoMessageType.USERID, (List<String>)p.fields(), this.timezone));
                break;
            }
            default: {
                if (((String)p.fields().get(5)).equals("GLOBALPROTECT")) {
                    message.addFields((Map<String, Object>)this.fieldProducer.parseFields(PaloAltoMessageType.GLOBAL_PROTECT_PRE_9_1_3, (List<String>)p.fields(), this.timezone));
                    break;
                }
                LOG.info("Received log for unsupported PAN type [{}]. Will not parse.", (Object)p.panType());
            }
        }
        message.addField("event_source_product", "PAN");
        if (this.configuration.getBoolean(CK_STORE_FULL_MESSAGE)) {
            message.addField("full_message", new String(rawMessage.getPayload(), StandardCharsets.UTF_8));
        }
        LOG.trace("Successfully processed [{}] message with [{}] fields.", (Object)p.panType(), (Object)message.getFieldCount());
        return message;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    @Nonnull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    @Nullable
    public CodecAggregator getAggregator() {
        return null;
    }

    @ConfigClass
    public static class Config
    implements Codec.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest r = new ConfigurationRequest();
            r.addField(new DropdownField(PaloAlto9xCodec.CK_TIMEZONE, "Time Zone", DateTimeZone.UTC.getID(), DropdownField.ValueTemplates.timeZones(), "Time zone of the Palo Alto device", ConfigurationField.Optional.OPTIONAL));
            r.addField(new BooleanField(PaloAlto9xCodec.CK_STORE_FULL_MESSAGE, "Store full message?", false, "Store the full original Palo Alto message as full_message?"));
            return r;
        }

        @Override
        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<PaloAlto9xCodec> {
        @Override
        public PaloAlto9xCodec create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

