/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.inputs.paloalto9;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.graylog.integrations.inputs.paloalto.PaloAltoMessageType;
import org.graylog.integrations.inputs.paloalto.PaloAltoTypeParser;
import org.graylog.integrations.inputs.paloalto9.PaloAlto9xTemplates;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaloAlto9xParser {
    private static final Logger LOG = LoggerFactory.getLogger(PaloAlto9xParser.class);
    private final Map<PaloAltoMessageType, PaloAltoTypeParser> parsers = Maps.newHashMap();

    public PaloAlto9xParser() {
        this(new PaloAltoTypeParser(PaloAlto9xTemplates.configTemplate()), new PaloAltoTypeParser(PaloAlto9xTemplates.correlationTemplate()), new PaloAltoTypeParser(PaloAlto9xTemplates.globalProtectPre913Template()), new PaloAltoTypeParser(PaloAlto9xTemplates.globalProtect913Template()), new PaloAltoTypeParser(PaloAlto9xTemplates.hipTemplate()), new PaloAltoTypeParser(PaloAlto9xTemplates.systemTemplate()), new PaloAltoTypeParser(PaloAlto9xTemplates.threatTemplate()), new PaloAltoTypeParser(PaloAlto9xTemplates.trafficTemplate()), new PaloAltoTypeParser(PaloAlto9xTemplates.userIdTemplate()));
    }

    @VisibleForTesting
    PaloAlto9xParser(PaloAltoTypeParser configParser, PaloAltoTypeParser correlationParser, PaloAltoTypeParser globalProtectPre913Parser, PaloAltoTypeParser globalProtect913Parser, PaloAltoTypeParser hipParser, PaloAltoTypeParser systemParser, PaloAltoTypeParser threatParser, PaloAltoTypeParser trafficParser, PaloAltoTypeParser userIdParser) {
        this.parsers.put(PaloAltoMessageType.CONFIG, configParser);
        this.parsers.put(PaloAltoMessageType.CORRELATION, correlationParser);
        this.parsers.put(PaloAltoMessageType.GLOBAL_PROTECT_PRE_9_1_3, globalProtectPre913Parser);
        this.parsers.put(PaloAltoMessageType.GLOBAL_PROTECT_9_1_3, globalProtect913Parser);
        this.parsers.put(PaloAltoMessageType.HIP, hipParser);
        this.parsers.put(PaloAltoMessageType.SYSTEM, systemParser);
        this.parsers.put(PaloAltoMessageType.THREAT, threatParser);
        this.parsers.put(PaloAltoMessageType.TRAFFIC, trafficParser);
        this.parsers.put(PaloAltoMessageType.USERID, userIdParser);
    }

    public ImmutableMap<String, Object> parseFields(PaloAltoMessageType type, List<String> fields, DateTimeZone timezone) {
        if (this.parsers.containsKey((Object)type)) {
            PaloAltoTypeParser parser = this.parsers.get((Object)type);
            return parser.parseFields(fields, timezone);
        }
        LOG.info("Received log for unsupported PAN type [{}]. Will not parse.", (Object)type);
        return ImmutableMap.of();
    }
}

