/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.ipfix;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.graylog.integrations.ipfix.InformationElementDefinition;
import org.graylog.integrations.ipfix.IpfixException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformationElementDefinitions {
    private static final Logger LOG = LoggerFactory.getLogger(InformationElementDefinitions.class);
    private Map<Long, Map<Integer, InformationElementDefinition>> penToIedsMap = Maps.newHashMap();

    public InformationElementDefinitions(URL ... definitionFiles) {
        LOG.debug("Reading information element definition file with private enterprise numbers.");
        ObjectMapper objectMapper = new ObjectMapper();
        for (URL file : definitionFiles) {
            try {
                JsonNode jsonNode = objectMapper.readTree(file);
                long enterpriseNumber = jsonNode.get("enterprise_number").asLong();
                ImmutableMap.Builder iedBuilder = ImmutableMap.builder();
                jsonNode.path("information_elements").elements().forEachRemaining(ied -> {
                    int elementId = ied.get("element_id").asInt();
                    String dataType = ied.get("data_type").asText();
                    String fieldName = ied.get("name").asText();
                    iedBuilder.put((Object)elementId, (Object)InformationElementDefinition.create(dataType, fieldName, elementId));
                });
                this.penToIedsMap.put(enterpriseNumber, (Map<Integer, InformationElementDefinition>)iedBuilder.build());
            }
            catch (IOException e) {
                LOG.error("Unable to read information element definition file", (Throwable)e);
            }
        }
    }

    Map<Long, Map<Integer, InformationElementDefinition>> buildPenToIedsMap(JsonNode jsonNode) {
        long enterpriseNumber = jsonNode.get("enterprise_number").asLong();
        ImmutableMap.Builder iedBuilder = ImmutableMap.builder();
        jsonNode.path("information_elements").elements().forEachRemaining(ied -> {
            int elementId = ied.get("element_id").asInt();
            String dataType = ied.get("data_type").asText();
            String fieldName = ied.get("name").asText();
            iedBuilder.put((Object)elementId, (Object)InformationElementDefinition.create(dataType, fieldName, elementId));
        });
        this.penToIedsMap.put(enterpriseNumber, (Map<Integer, InformationElementDefinition>)iedBuilder.build());
        return this.penToIedsMap;
    }

    public static InformationElementDefinitions empty() {
        return new InformationElementDefinitions(new URL[0]);
    }

    public InformationElementDefinition getDefinition(int id, long enterpriseNumber) {
        Map<Integer, InformationElementDefinition> penMapping = this.penToIedsMap.get(enterpriseNumber);
        if (penMapping == null) {
            throw new IpfixException("Missing information element definitions for private enterprise number " + enterpriseNumber);
        }
        return penMapping.get(id);
    }
}

