/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.migrations;

import java.time.ZonedDateTime;
import java.util.List;
import javax.inject.Inject;
import org.graylog2.lookup.db.DBDataAdapterService;
import org.graylog2.migrations.Migration;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.shared.utilities.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20230522201200_NotificationForDeprecatedGreyNoiseCommunityDataAdapters
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20230522201200_NotificationForDeprecatedGreyNoiseCommunityDataAdapters.class);
    private final ClusterConfigService clusterConfigService;
    private final DBDataAdapterService dataAdapterService;
    private final NotificationService notificationService;

    @Inject
    public V20230522201200_NotificationForDeprecatedGreyNoiseCommunityDataAdapters(ClusterConfigService clusterConfigService, DBDataAdapterService dataAdapterService, NotificationService notificationService) {
        this.clusterConfigService = clusterConfigService;
        this.dataAdapterService = dataAdapterService;
        this.notificationService = notificationService;
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed!");
            return;
        }
        List<String> greyNoiseCommunityAdapters = this.dataAdapterService.findAll().stream().filter(da -> da.config().type().equals("GreyNoise Community IP Lookup")).map(da -> da.name()).toList();
        if (!greyNoiseCommunityAdapters.isEmpty()) {
            Notification systemNotification = this.notificationService.buildNow().addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.URGENT).addDetail("title", StringUtils.f("Disabled Data Adapters %s", greyNoiseCommunityAdapters.toString())).addDetail("description", "GreyNoise Community IP Lookup Data Adapters are no longer supported as of Graylog 5.2. GreyNoise Community Data Adapters will no longer return results and should be deleted.");
            this.notificationService.publishIfFirst(systemNotification);
        }
        this.clusterConfigService.write(new MigrationCompleted());
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-05-22T20:12:00Z");
    }

    public record MigrationCompleted() {
    }
}

