/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.pagerduty;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.graylog.events.notifications.EventNotification;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.notifications.EventNotificationException;
import org.graylog.events.notifications.PermanentEventNotificationException;
import org.graylog.events.notifications.TemporaryEventNotificationException;
import org.graylog.integrations.pagerduty.client.MessageFactory;
import org.graylog.integrations.pagerduty.client.PagerDutyClient;
import org.graylog.integrations.pagerduty.dto.PagerDutyResponse;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.system.NodeId;

public class PagerDutyNotification
implements EventNotification {
    private final PagerDutyClient pagerDutyClient;
    private final MessageFactory messageFactory;
    private final ObjectMapper objectMapper;
    private final NotificationService notificationService;
    private final NodeId nodeId;

    @Inject
    PagerDutyNotification(PagerDutyClient pagerDutyClient, MessageFactory messageFactory, ObjectMapper objectMapper, NotificationService notificationService, NodeId nodeId) {
        this.pagerDutyClient = pagerDutyClient;
        this.messageFactory = messageFactory;
        this.objectMapper = objectMapper;
        this.notificationService = notificationService;
        this.nodeId = nodeId;
    }

    @Override
    public void execute(EventNotificationContext ctx) throws EventNotificationException {
        String payloadString = this.buildRequestBody(ctx);
        try {
            PagerDutyResponse response = this.pagerDutyClient.enqueue(payloadString);
            List<String> errors = response.getErrors();
            if (errors != null && errors.size() > 0) {
                throw new IllegalStateException("There was an error triggering the PagerDuty event, details: " + errors);
            }
        }
        catch (PagerDutyClient.TemporaryPagerDutyClientException e) {
            throw new TemporaryEventNotificationException(String.format(Locale.ROOT, "Error enqueueing the PagerDuty event :: %s", e.getMessage()), null != e.getCause() ? e.getCause() : e);
        }
        catch (PagerDutyClient.PermanentPagerDutyClientException e) {
            String errorMessage = String.format(Locale.ROOT, "Error enqueueing the PagerDuty event :: %s", e.getMessage());
            Notification systemNotification = this.notificationService.buildNow().addNode(this.nodeId.getNodeId()).addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.URGENT).addDetail("title", "PagerDuty Notification Failed").addDetail("description", errorMessage);
            this.notificationService.publishIfFirst(systemNotification);
            throw new PermanentEventNotificationException(errorMessage, null != e.getCause() ? e.getCause() : e);
        }
        catch (Throwable t) {
            throw new EventNotificationException("There was an exception triggering the PagerDuty event.", t);
        }
    }

    private String buildRequestBody(EventNotificationContext ctx) throws PermanentEventNotificationException {
        try {
            return this.objectMapper.writeValueAsString((Object)this.messageFactory.createTriggerMessage(ctx));
        }
        catch (IOException e) {
            throw new PermanentEventNotificationException("Failed to build payload for PagerDuty API", e);
        }
    }

    public static interface Factory
    extends EventNotification.Factory {
        public PagerDutyNotification create();
    }
}

