/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.pagerduty.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Locale;
import javax.inject.Inject;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.graylog.integrations.pagerduty.dto.PagerDutyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagerDutyClient {
    private static final Logger LOG = LoggerFactory.getLogger(PagerDutyClient.class);
    @VisibleForTesting
    static final String API_URL = "https://events.pagerduty.com/v2/enqueue";
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;

    @Inject
    public PagerDutyClient(OkHttpClient httpClient, ObjectMapper objectMapper) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    public PagerDutyResponse enqueue(String payloadString) throws TemporaryPagerDutyClientException, PermanentPagerDutyClientException {
        PagerDutyResponse pagerDutyResponse;
        block11: {
            Request request = new Request.Builder().url(API_URL).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)payloadString)).build();
            LOG.debug("Triggering event in PagerDuty with POST payload: {}", (Object)payloadString);
            Response response = this.httpClient.newCall(request).execute();
            try {
                String responseBody = response.body().string();
                LOG.debug("PagerDuty POST completed in {}ms [HTTP {}].  Response body: {}", new Object[]{response.receivedResponseAtMillis() - response.sentRequestAtMillis(), response.code(), responseBody});
                if (!response.isSuccessful()) {
                    if (400 == response.code()) {
                        throw new PermanentPagerDutyClientException(String.format(Locale.ROOT, "Invalid request sent to PagerDuty [%s]", response.body().string()));
                    }
                    if (429 == response.code()) {
                        throw new TemporaryPagerDutyClientException("Too many PagerDuty API calls at one time");
                    }
                    throw new TemporaryPagerDutyClientException(String.format(Locale.ROOT, "HTTP %d - PagerDuty server encountered an internal error", response.code()));
                }
                pagerDutyResponse = (PagerDutyResponse)this.objectMapper.readValue(responseBody, PagerDutyResponse.class);
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Error sending PagerDuty notification event: " + e.getMessage());
                    throw new TemporaryPagerDutyClientException("There was an error sending the notification event.", e);
                }
            }
            response.close();
        }
        return pagerDutyResponse;
    }

    public static class PermanentPagerDutyClientException
    extends Exception {
        public PermanentPagerDutyClientException(String msg) {
            super(msg);
        }

        public PermanentPagerDutyClientException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static class TemporaryPagerDutyClientException
    extends Exception {
        public TemporaryPagerDutyClientException(String msg) {
            super(msg);
        }

        public TemporaryPagerDutyClientException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

