/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.graylog.plugins.map.config.DatabaseType;
import org.graylog.plugins.map.geoip.AutoValue_MaxmindDataAdapter_Config;
import org.graylog.plugins.map.geoip.MaxmindDataAdapter;

abstract class $AutoValue_MaxmindDataAdapter_Config
extends MaxmindDataAdapter.Config {
    private final String type;
    @NotEmpty
    private final String path;
    @NotNull
    private final DatabaseType dbType;
    @Min(value=0L)
    private final @Min(value=0L) long checkInterval;
    @Nullable
    private final TimeUnit checkIntervalUnit;

    $AutoValue_MaxmindDataAdapter_Config(String type, @NotEmpty String path, @NotNull DatabaseType dbType, @Min(value=0L) @Min(value=0L) long checkInterval, @Nullable TimeUnit checkIntervalUnit) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        if (path == null) {
            throw new NullPointerException("Null path");
        }
        this.path = path;
        if (dbType == null) {
            throw new NullPointerException("Null dbType");
        }
        this.dbType = dbType;
        this.checkInterval = checkInterval;
        this.checkIntervalUnit = checkIntervalUnit;
    }

    @Override
    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="path")
    @NotEmpty
    public String path() {
        return this.path;
    }

    @Override
    @JsonProperty(value="database_type")
    @NotNull
    public DatabaseType dbType() {
        return this.dbType;
    }

    @Override
    @JsonProperty(value="check_interval")
    @Min(value=0L)
    public @Min(value=0L) long checkInterval() {
        return this.checkInterval;
    }

    @Override
    @JsonProperty(value="check_interval_unit")
    @Nullable
    public TimeUnit checkIntervalUnit() {
        return this.checkIntervalUnit;
    }

    public String toString() {
        return "Config{type=" + this.type + ", path=" + this.path + ", dbType=" + this.dbType + ", checkInterval=" + this.checkInterval + ", checkIntervalUnit=" + this.checkIntervalUnit + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MaxmindDataAdapter.Config) {
            MaxmindDataAdapter.Config that = (MaxmindDataAdapter.Config)o;
            return this.type.equals(that.type()) && this.path.equals(that.path()) && this.dbType.equals((Object)that.dbType()) && this.checkInterval == that.checkInterval() && (this.checkIntervalUnit == null ? that.checkIntervalUnit() == null : this.checkIntervalUnit.equals((Object)that.checkIntervalUnit()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.path.hashCode();
        h$ *= 1000003;
        h$ ^= this.dbType.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.checkInterval >>> 32 ^ this.checkInterval);
        h$ *= 1000003;
        return h$ ^= this.checkIntervalUnit == null ? 0 : this.checkIntervalUnit.hashCode();
    }

    static class Builder
    extends MaxmindDataAdapter.Config.Builder {
        private String type;
        @NotEmpty
        private String path;
        @NotNull
        private DatabaseType dbType;
        @Min(value=0L)
        private @Min(value=0L) long checkInterval;
        private TimeUnit checkIntervalUnit;
        private byte set$0;

        Builder() {
        }

        @Override
        public MaxmindDataAdapter.Config.Builder type(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public MaxmindDataAdapter.Config.Builder path(String path) {
            if (path == null) {
                throw new NullPointerException("Null path");
            }
            this.path = path;
            return this;
        }

        @Override
        public MaxmindDataAdapter.Config.Builder dbType(DatabaseType dbType) {
            if (dbType == null) {
                throw new NullPointerException("Null dbType");
            }
            this.dbType = dbType;
            return this;
        }

        @Override
        public MaxmindDataAdapter.Config.Builder checkInterval(long checkInterval) {
            this.checkInterval = checkInterval;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public MaxmindDataAdapter.Config.Builder checkIntervalUnit(@Nullable TimeUnit checkIntervalUnit) {
            this.checkIntervalUnit = checkIntervalUnit;
            return this;
        }

        @Override
        public MaxmindDataAdapter.Config build() {
            if (this.set$0 != 1 || this.type == null || this.path == null || this.dbType == null) {
                StringBuilder missing = new StringBuilder();
                if (this.type == null) {
                    missing.append(" type");
                }
                if (this.path == null) {
                    missing.append(" path");
                }
                if (this.dbType == null) {
                    missing.append(" dbType");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" checkInterval");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_MaxmindDataAdapter_Config(this.type, this.path, this.dbType, this.checkInterval, this.checkIntervalUnit);
        }
    }
}

