/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.map.config.GeoIpResolverConfig;
import org.graylog.plugins.map.config.S3GeoIpFileService;
import org.graylog.plugins.map.geoip.GeoAsnInformation;
import org.graylog.plugins.map.geoip.GeoIpResolver;
import org.graylog.plugins.map.geoip.GeoIpVendorResolverService;
import org.graylog.plugins.map.geoip.GeoLocationInformation;
import org.graylog2.plugin.Message;
import org.graylog2.utilities.ReservedIpChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIpResolverEngine {
    private static final Logger LOG = LoggerFactory.getLogger(GeoIpResolverEngine.class);
    private static final String[] KNOWN_SCHEMA_IP_FIELDS = new String[]{"destination_ip", "destination_nat_ip", "event_observer_ip", "source_nat_ip", "network_forwarded_ip", "source_ip", "host_ip"};
    private final Map<String, String> ipAddressFields = Stream.of(KNOWN_SCHEMA_IP_FIELDS).collect(Collectors.toMap(e -> e, GeoIpResolverEngine.mapFieldNameToPrefix()));
    private final GeoIpResolver<GeoLocationInformation> ipLocationResolver;
    private final GeoIpResolver<GeoAsnInformation> ipAsnResolver;
    private final boolean enabled;
    private final boolean enforceGraylogSchema;

    public GeoIpResolverEngine(GeoIpVendorResolverService resolverService, GeoIpResolverConfig config, S3GeoIpFileService s3GeoIpFileService, MetricRegistry metricRegistry) {
        Timer resolveTime = metricRegistry.timer(MetricRegistry.name(GeoIpResolverEngine.class, (String[])new String[]{"resolveTime"}));
        this.enforceGraylogSchema = config.enforceGraylogSchema();
        if (config.useS3()) {
            config = config.toBuilder().asnDbPath(s3GeoIpFileService.getActiveAsnFile()).cityDbPath(s3GeoIpFileService.getActiveCityFile()).build();
        }
        this.ipLocationResolver = resolverService.createCityResolver(config, resolveTime);
        this.ipAsnResolver = resolverService.createAsnResolver(config, resolveTime);
        LOG.debug("Created Geo IP Resolvers for '{}'", (Object)config.databaseVendorType());
        LOG.debug("'{}' Status Enabled: {}", (Object)this.ipLocationResolver.getClass().getSimpleName(), (Object)this.ipLocationResolver.isEnabled());
        LOG.debug("'{}' Status Enabled: {}", (Object)this.ipAsnResolver.getClass().getSimpleName(), (Object)this.ipAsnResolver.isEnabled());
        this.enabled = this.ipLocationResolver.isEnabled() || this.ipAsnResolver.isEnabled();
    }

    public boolean filter(Message message) {
        if (!this.enabled) {
            return false;
        }
        List<String> ipFields = this.getIpAddressFields(message);
        for (String key : ipFields) {
            String prefix;
            Object fieldValue = message.getField(key);
            InetAddress address = this.getValidRoutableInetAddress(fieldValue);
            if (address == null) continue;
            String string = prefix = this.enforceGraylogSchema ? this.ipAddressFields.getOrDefault(key, key) : key;
            if (ReservedIpChecker.getInstance().isReservedIpAddress(address.getHostAddress())) {
                message.addField(prefix + "_reserved_ip", true);
                continue;
            }
            if (this.enforceGraylogSchema) {
                this.addGIMGeoIpDataIfPresent(message, address, prefix);
                continue;
            }
            this.addLegacyGeoIpDataIfPresent(message, address, prefix);
        }
        return true;
    }

    private void addLegacyGeoIpDataIfPresent(Message message, InetAddress address, String key) {
        this.ipLocationResolver.getGeoIpData(address).ifPresent(locationInformation -> {
            message.addField(key + "_geolocation", locationInformation.latitude() + "," + locationInformation.longitude());
            message.addField(key + "_country_code", locationInformation.countryIsoCode());
            message.addField(key + "_city_name", locationInformation.cityName());
        });
    }

    private void addGIMGeoIpDataIfPresent(Message message, InetAddress address, String newFieldPrefix) {
        this.ipLocationResolver.getGeoIpData(address).ifPresent(locationInformation -> {
            message.addField(newFieldPrefix + "_geo_coordinates", locationInformation.latitude() + "," + locationInformation.longitude());
            message.addField(newFieldPrefix + "_geo_country_iso", locationInformation.countryIsoCode());
            message.addField(newFieldPrefix + "_geo_city", locationInformation.cityName());
            message.addField(newFieldPrefix + "_geo_region", locationInformation.region());
            message.addField(newFieldPrefix + "_geo_timezone", locationInformation.timeZone());
            if (this.areValidGeoNames(locationInformation.countryName())) {
                message.addField(newFieldPrefix + "_geo_country", locationInformation.countryName());
            }
            if (this.areValidGeoNames(locationInformation.cityName(), locationInformation.countryIsoCode())) {
                String name = String.format(Locale.ENGLISH, "%s, %s", locationInformation.cityName(), locationInformation.countryIsoCode());
                message.addField(newFieldPrefix + "_geo_name", name);
            }
        });
        this.ipAsnResolver.getGeoIpData(address).ifPresent(info -> {
            message.addField(newFieldPrefix + "_as_organization", info.organization());
            message.addField(newFieldPrefix + "_as_number", info.asn());
        });
    }

    @VisibleForTesting
    List<String> getIpAddressFields(Message message) {
        return message.getFieldNames().stream().filter((? super T e) -> (!this.enforceGraylogSchema || this.ipAddressFields.containsKey(e)) && !e.startsWith("gl2_")).collect(Collectors.toList());
    }

    private InetAddress getValidRoutableInetAddress(Object fieldValue) {
        InetAddress ipAddress = fieldValue instanceof InetAddress ? (InetAddress)fieldValue : (fieldValue instanceof String ? this.getIpFromFieldValue((String)fieldValue) : null);
        return ipAddress;
    }

    private boolean areValidGeoNames(String ... names) {
        for (String name : names) {
            if (!StringUtils.isBlank((CharSequence)name) && !"N/A".equalsIgnoreCase(name)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    @VisibleForTesting
    InetAddress getIpFromFieldValue(String fieldValue) {
        try {
            return InetAddresses.forString((String)fieldValue.trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static Function<String, String> mapFieldNameToPrefix() {
        return string -> string.replace("_ip", "");
    }
}

