/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.codahale.metrics.Timer;
import javax.inject.Inject;
import org.graylog.plugins.map.config.GeoIpResolverConfig;
import org.graylog.plugins.map.geoip.GeoAsnInformation;
import org.graylog.plugins.map.geoip.GeoIpResolver;
import org.graylog.plugins.map.geoip.GeoIpResolverFactory;
import org.graylog.plugins.map.geoip.GeoLocationInformation;

public class GeoIpVendorResolverService {
    private final GeoIpResolverFactory resolverFactory;

    @Inject
    public GeoIpVendorResolverService(GeoIpResolverFactory resolverFactory) {
        this.resolverFactory = resolverFactory;
    }

    public GeoIpResolver<GeoLocationInformation> createCityResolver(GeoIpResolverConfig config, Timer timer) {
        switch (config.databaseVendorType()) {
            case IPINFO: {
                return this.resolverFactory.createIpInfoCityResolver(timer, config.cityDbPath(), config.enabled());
            }
            case MAXMIND: {
                return this.resolverFactory.createMaxMindCityResolver(timer, config.cityDbPath(), config.enabled());
            }
        }
        throw new IllegalArgumentException(config.databaseVendorType().name());
    }

    public GeoIpResolver<GeoAsnInformation> createAsnResolver(GeoIpResolverConfig config, Timer timer) {
        switch (config.databaseVendorType()) {
            case IPINFO: {
                return this.resolverFactory.createIpInfoAsnResolver(timer, config.asnDbPath(), config.enabled());
            }
            case MAXMIND: {
                return this.resolverFactory.createMaxMindAsnResolver(timer, config.asnDbPath(), config.enabled());
            }
        }
        throw new IllegalArgumentException(config.databaseVendorType().name());
    }
}

