/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.functions;

import com.google.common.collect.ImmutableList;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.util.Map;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.exceptions.PrecomputeFailure;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;

public interface Function<T> {
    public static final RateLimitedLog log = PipelineInterpreter.getRateLimitedLog(Function.class);
    public static final Function ERROR_FUNCTION = new AbstractFunction<Void>(){

        @Override
        public Void evaluate(FunctionArgs args, EvaluationContext context) {
            return null;
        }

        @Override
        public void preprocessArgs(FunctionArgs args) {
        }

        @Override
        public FunctionDescriptor<Void> descriptor() {
            return FunctionDescriptor.builder().name("__unresolved_function").returnType(Void.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of()).build();
        }
    };

    default public void preprocessArgs(FunctionArgs args) {
        for (Map.Entry<String, Expression> e : args.getConstantArgs().entrySet()) {
            String name = e.getKey();
            try {
                Object value = this.preComputeConstantArgument(args, name, e.getValue());
                if (value == null) continue;
                ParameterDescriptor<?, ?> param = args.param(name);
                if (param == null) {
                    throw new IllegalStateException("Unknown parameter " + name + "! Cannot continue.");
                }
                args.setPreComputedValue(name, param.transform().apply(value));
            }
            catch (Exception exception) {
                log.debug("Unable to precompute argument value for " + name, (Throwable)exception);
                throw new PrecomputeFailure(name, exception);
            }
        }
    }

    public Object preComputeConstantArgument(FunctionArgs var1, String var2, Expression var3);

    public T evaluate(FunctionArgs var1, EvaluationContext var2);

    public FunctionDescriptor<T> descriptor();
}

