/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.mongodb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.db.PipelineDao;
import org.graylog.plugins.pipelineprocessor.db.PipelineService;
import org.graylog.plugins.pipelineprocessor.events.PipelinesChangedEvent;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class MongoDbPipelineService
implements PipelineService {
    private static final RateLimitedLog log = PipelineInterpreter.getRateLimitedLog(MongoDbPipelineService.class);
    public static final String COLLECTION = "pipeline_processor_pipelines";
    private final JacksonDBCollection<PipelineDao, String> dbCollection;
    private final ClusterEventBus clusterBus;

    @Inject
    public MongoDbPipelineService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, ClusterEventBus clusterBus) {
        this.dbCollection = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION), PipelineDao.class, String.class, (ObjectMapper)mapper.get());
        this.clusterBus = clusterBus;
        this.dbCollection.createIndex((DBObject)DBSort.asc((String)"title"), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    @Override
    public PipelineDao save(PipelineDao pipeline) {
        WriteResult save = this.dbCollection.save((Object)pipeline);
        PipelineDao savedPipeline = (PipelineDao)save.getSavedObject();
        this.clusterBus.post(PipelinesChangedEvent.updatedPipelineId(savedPipeline.id()));
        return savedPipeline;
    }

    @Override
    public PipelineDao load(String id) throws NotFoundException {
        PipelineDao pipeline = (PipelineDao)this.dbCollection.findOneById((Object)id);
        if (pipeline == null) {
            throw new NotFoundException("No pipeline with id " + id);
        }
        return pipeline;
    }

    @Override
    public PipelineDao loadByName(String name) throws NotFoundException {
        DBQuery.Query query = DBQuery.is((String)"title", (Object)name);
        PipelineDao pipeline = (PipelineDao)this.dbCollection.findOne(query);
        if (pipeline == null) {
            throw new NotFoundException("No pipeline with name " + name);
        }
        return pipeline;
    }

    @Override
    public Collection<PipelineDao> loadAll() {
        ImmutableSet immutableSet;
        block8: {
            DBCursor daos = this.dbCollection.find();
            try {
                immutableSet = ImmutableSet.copyOf((Iterator)daos);
                if (daos == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (daos != null) {
                        try {
                            daos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MongoException e) {
                    log.error("Unable to load pipelines", (Throwable)e);
                    return Collections.emptySet();
                }
            }
            daos.close();
        }
        return immutableSet;
    }

    @Override
    public void delete(String id) {
        this.dbCollection.removeById((Object)id);
        this.clusterBus.post(PipelinesChangedEvent.deletedPipelineId(id));
    }

    @Override
    public long count(DBQuery.Query query) {
        return this.dbCollection.getCount(query);
    }
}

