/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.dates;

import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.annotation.Nonnull;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.dates.TimezoneAwareFunction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DateConversion
extends TimezoneAwareFunction {
    public static final String NAME = "to_date";
    private final ParameterDescriptor<Object, Object> value = ParameterDescriptor.object("value").ruleBuilderVariable().description("The value to convert to a date").build();

    @Override
    protected DateTime evaluate(FunctionArgs args, EvaluationContext context, DateTimeZone timezone) {
        Object datish = this.value.required(args, context);
        DateTime result = null;
        if (datish instanceof DateTime) {
            result = (DateTime)datish;
        }
        if (datish instanceof Date) {
            result = new DateTime(datish);
        }
        if (datish instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)datish;
            DateTimeZone timeZone = DateTimeZone.forID((String)zonedDateTime.getZone().getId());
            result = new DateTime(zonedDateTime.toInstant().toEpochMilli(), timeZone);
        }
        if (timezone != null && result != null) {
            result = result.withZone(timezone);
        }
        return result;
    }

    @Override
    protected String description() {
        return "Converts a type to a date, useful for $message.timestamp or related message fields. Does not handle date parsing from strings.";
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected ImmutableList<ParameterDescriptor> params() {
        return ImmutableList.of(this.value);
    }

    @Override
    @Nonnull
    protected String getRuleBuilderName() {
        return "Convert to date";
    }

    @Override
    @Nonnull
    protected String getRuleBuilderTitle() {
        return "Convert '${value}' to a DateTime";
    }
}

