/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.dates;

import com.google.common.collect.ImmutableList;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class FormatDate
extends AbstractFunction<String> {
    public static final String NAME = "format_date";
    private final ParameterDescriptor<DateTime, DateTime> value = ParameterDescriptor.type("value", DateTime.class).description("The date to format").ruleBuilderVariable().build();
    private final ParameterDescriptor<String, DateTimeFormatter> format = ParameterDescriptor.string("format", DateTimeFormatter.class).transform(DateTimeFormat::forPattern).description("The format string to use, see http://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html").build();
    private final ParameterDescriptor<String, DateTimeZone> timeZoneParam = ParameterDescriptor.string("timezone", DateTimeZone.class).transform(DateTimeZone::forID).optional().description("The timezone to apply to the date, defaults to UTC").build();

    @Override
    public String evaluate(FunctionArgs args, EvaluationContext context) {
        DateTime dateTime = this.value.required(args, context);
        DateTimeFormatter formatter = this.format.required(args, context);
        if (dateTime == null || formatter == null) {
            return null;
        }
        DateTimeZone timeZone = this.timeZoneParam.optional(args, context).orElse(DateTimeZone.UTC);
        return formatter.withZone(timeZone).print((ReadableInstant)dateTime);
    }

    @Override
    public FunctionDescriptor<String> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(String.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.value, this.format, this.timeZoneParam)).description("Formats a date and time according to a given formatter pattern.").ruleBuilderEnabled().ruleBuilderName("Format date").ruleBuilderTitle("Format '${value}' as date (format '${format}')").build();
    }
}

