/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.dates.periods;

import com.google.common.primitives.Ints;
import javax.annotation.Nonnull;
import org.graylog.plugins.pipelineprocessor.functions.dates.periods.AbstractPeriodComponentFunction;
import org.joda.time.Period;

public class Years
extends AbstractPeriodComponentFunction {
    public static final String NAME = "years";

    @Override
    @Nonnull
    protected Period getPeriod(int period) {
        return Period.years((int)Ints.saturatedCast((long)period));
    }

    @Override
    @Nonnull
    protected String getName() {
        return NAME;
    }

    @Override
    @Nonnull
    protected String getDescription() {
        return "Create a period with a specified number of years.";
    }

    @Override
    @Nonnull
    protected String getRuleBuilderName() {
        return "Create period (years)";
    }

    @Override
    @Nonnull
    protected String getRuleBuilderTitle() {
        return "Create a time period of '${value}' years";
    }
}

