/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.functions.json.AutoValue_JsonUtils_Entry;
import org.graylog.plugins.pipelineprocessor.functions.json.AutoValue_JsonUtils_ExtractFlags;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog2.jackson.TypeReferences;

public class JsonUtils {
    private static final RateLimitedLog LOG = PipelineInterpreter.getRateLimitedLog(JsonUtils.class);
    private static final String KEY_SEPARATOR = "_";
    private static final String KEY_VALUE_SEPARATOR = ":";
    private static final String LIST_SEPARATOR = ",";
    private static final RemoveNullPredicate<Map.Entry<String, Object>> REMOVE_NULL_PREDICATE = new RemoveNullPredicate();

    private JsonUtils() {
    }

    public static JsonNode extractJson(String value, ObjectMapper mapper, ExtractFlags extractFlags, boolean stringify) throws IOException {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IOException("null result");
        }
        Map json = (Map)mapper.readValue(value, TypeReferences.MAP_STRING_OBJECT);
        ObjectNode resultRoot = mapper.createObjectNode();
        for (Map.Entry mapEntry : json.entrySet()) {
            for (Entry entry : JsonUtils.parseValue((String)mapEntry.getKey(), mapEntry.getValue(), mapper, extractFlags)) {
                if (stringify) {
                    resultRoot.put(entry.key(), entry.value().toString());
                    continue;
                }
                resultRoot.putPOJO(entry.key(), entry.value());
            }
        }
        return resultRoot;
    }

    private static Collection<Entry> parseValue(String key, Object value, ObjectMapper mapper, ExtractFlags extractFlags) throws JsonProcessingException {
        if (value instanceof Boolean || value instanceof Number || value instanceof String) {
            return Collections.singleton(Entry.create(key, value));
        }
        if (value instanceof Map) {
            return JsonUtils.parseObject(key, (Map)value, mapper, extractFlags);
        }
        if (value instanceof List) {
            return JsonUtils.parseArray(key, (List)value, mapper, extractFlags);
        }
        if (value == null) {
            return Collections.emptySet();
        }
        LOG.debug("Unknown type \"{}\" in key \"{}\"", value.getClass(), (Object)key);
        return Collections.emptySet();
    }

    private static Collection<Entry> parseObject(String key, Map<String, Object> value, ObjectMapper mapper, ExtractFlags extractFlags) throws JsonProcessingException {
        Map mapWithoutNull = Maps.filterEntries(value, REMOVE_NULL_PREDICATE);
        if (extractFlags.flattenObjects()) {
            ArrayList<Entry> result = new ArrayList<Entry>(mapWithoutNull.size());
            for (Map.Entry entry : mapWithoutNull.entrySet()) {
                result.addAll(JsonUtils.parseValue(key + KEY_SEPARATOR + (String)entry.getKey(), entry.getValue(), mapper, extractFlags));
            }
            return result;
        }
        Joiner.MapJoiner joiner = Joiner.on((String)LIST_SEPARATOR).withKeyValueSeparator(KEY_VALUE_SEPARATOR);
        return Collections.singleton(Entry.create(key, joiner.join(mapWithoutNull)));
    }

    private static Collection<Entry> parseArray(String key, List<Object> value, ObjectMapper mapper, ExtractFlags extractFlags) throws JsonProcessingException {
        if (extractFlags.deleteArrays()) {
            return Collections.emptySet();
        }
        if (extractFlags.escapeArrays()) {
            return Collections.singleton(Entry.create(key, mapper.writeValueAsString(value)));
        }
        int listSize = value.size();
        ArrayList<Entry> result = new ArrayList<Entry>(listSize);
        int index = 0;
        for (Object obj : value) {
            result.addAll(JsonUtils.parseValue(key + KEY_SEPARATOR + index, obj, mapper, extractFlags));
            ++index;
        }
        return result;
    }

    public static JsonNode deleteBelow(JsonNode root, long maxDepth) {
        if (maxDepth > 0L) {
            JsonUtils.deleteBelow(root, maxDepth, 1L);
        }
        return root;
    }

    private static void deleteBelow(JsonNode root, long maxDepth, long depth) {
        Iterator elements = root.elements();
        while (elements.hasNext()) {
            JsonNode node = (JsonNode)elements.next();
            if (!node.isContainerNode()) continue;
            if (depth >= maxDepth) {
                elements.remove();
                continue;
            }
            JsonUtils.deleteBelow(node, maxDepth, depth + 1L);
        }
    }

    @AutoValue
    protected static abstract class ExtractFlags {
        protected ExtractFlags() {
        }

        public abstract boolean flattenObjects();

        public abstract boolean escapeArrays();

        public abstract boolean deleteArrays();

        public static Builder builder() {
            return new AutoValue_JsonUtils_ExtractFlags.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder flattenObjects(boolean var1);

            public abstract Builder escapeArrays(boolean var1);

            public abstract Builder deleteArrays(boolean var1);

            public abstract ExtractFlags build();
        }
    }

    @AutoValue
    protected static abstract class Entry {
        protected Entry() {
        }

        public abstract String key();

        @Nullable
        public abstract Object value();

        public static Entry create(String key, @Nullable Object value) {
            return new AutoValue_JsonUtils_Entry(key, value);
        }
    }

    protected static final class RemoveNullPredicate<T extends Map.Entry>
    implements Predicate<T> {
        protected RemoveNullPredicate() {
        }

        public boolean apply(@Nullable Map.Entry input) {
            return input != null && input.getKey() != null && input.getValue() != null;
        }
    }
}

