/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.lookup;

import java.util.List;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog2.lookup.LookupTableService;

public class LookupRemoveStringList
extends AbstractFunction<Object> {
    public static final String NAME = "lookup_remove_string_list";
    private final ParameterDescriptor<String, LookupTableService.Function> lookupTableParam = ParameterDescriptor.string("lookup_table", LookupTableService.Function.class).description("The existing lookup table to use to remove entries from the given list").transform(tableName -> lookupTableService.newBuilder().lookupTable((String)tableName).build()).build();
    private final ParameterDescriptor<Object, Object> keyParam = ParameterDescriptor.object("key").description("The key to remove the entries in the lookup table").build();
    private final ParameterDescriptor<List, List> valueParam = ParameterDescriptor.type("value", List.class).description("The list value that should be removed from the lookup table").build();

    @Inject
    public LookupRemoveStringList(LookupTableService lookupTableService) {
    }

    @Override
    public Object evaluate(FunctionArgs args, EvaluationContext context) {
        Object key = this.keyParam.required(args, context);
        if (key == null) {
            return null;
        }
        LookupTableService.Function table = this.lookupTableParam.required(args, context);
        if (table == null) {
            return null;
        }
        List value = this.valueParam.required(args, context);
        if (value == null) {
            return null;
        }
        return table.removeStringList(key, value).stringListValue();
    }

    @Override
    public FunctionDescriptor<Object> descriptor() {
        return FunctionDescriptor.builder().name(NAME).description("Remove the entries of the given string list from the named lookup table. Returns the updated list on success, null on failure.").params(this.lookupTableParam, this.keyParam, this.valueParam).returnType(List.class).ruleBuilderEnabled().ruleBuilderName("Remove string list from lookup table").ruleBuilderTitle("Remove entries of string list from '${lookup_table}' using key '${key}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.LOOKUP).build();
    }
}

