/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.maps;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class MapRemove
extends AbstractFunction<Map> {
    public static final String NAME = "map_remove";
    private static final String KEYARG = "key";
    private static final String MAPARG = "map";
    private final ParameterDescriptor<Map, Map> mapParam = ParameterDescriptor.type("map", Map.class).ruleBuilderVariable().description("A map").build();
    private final ParameterDescriptor<String, String> keyParam = ParameterDescriptor.string("key").description("Remove this key from map").build();

    @Override
    public Map evaluate(FunctionArgs args, EvaluationContext context) {
        Map mapValue = this.mapParam.required(args, context);
        if (mapValue == null) {
            return null;
        }
        String keyValue = this.keyParam.required(args, context);
        if (Strings.isNullOrEmpty((String)keyValue)) {
            return mapValue;
        }
        mapValue.remove(keyValue);
        return mapValue;
    }

    @Override
    public FunctionDescriptor<Map> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Map.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.mapParam, this.keyParam)).description("Removes a key from the map").ruleBuilderEnabled().ruleBuilderName("Remove from map").ruleBuilderTitle("Remove '${key}' from map").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.OTHER).build();
    }
}

