/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import java.util.Map;
import java.util.stream.Collectors;

public class ShannonEntropy {
    public static double calculateForChars(String input) {
        Map<Character, Long> charCountMap = input.chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.groupingBy(p -> p, Collectors.counting()));
        double result = 0.0;
        for (Character c2 : charCountMap.keySet()) {
            double probabilityForChar = (double)charCountMap.get(c2).longValue() / (double)input.length();
            result += probabilityForChar * ShannonEntropy.logBaseTwo(1.0 / probabilityForChar);
        }
        return result;
    }

    private static double logBaseTwo(double input) {
        return Math.log(input) / Math.log(2.0);
    }
}

