/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.collect.ImmutableList;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public abstract class StringUtilsFunction
extends AbstractFunction<String> {
    private static final String VALUE = "value";
    private static final String LOCALE = "locale";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").ruleBuilderVariable().description("The input string").build();
    private final ParameterDescriptor<String, Locale> localeParam = ParameterDescriptor.string("locale", Locale.class).optional().transform(Locale::forLanguageTag).description("The locale to use, defaults to English").build();

    @Override
    public String evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        Locale locale = Locale.ENGLISH;
        if (this.isLocaleAware()) {
            locale = this.localeParam.optional(args, context).orElse(Locale.ENGLISH);
        }
        return this.apply(value, locale);
    }

    @Override
    public FunctionDescriptor<String> descriptor() {
        ImmutableList.Builder params = ImmutableList.builder();
        params.add(this.valueParam);
        if (this.isLocaleAware()) {
            params.add(this.localeParam);
        }
        return FunctionDescriptor.builder().name(this.getName()).returnType(String.class).params((ImmutableList<ParameterDescriptor>)params.build()).description(this.description()).ruleBuilderEnabled().ruleBuilderName(this.getRuleBuilderName()).ruleBuilderTitle(this.getRuleBuilderTitle()).ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.STRING).build();
    }

    protected abstract String getName();

    protected abstract String description();

    protected abstract boolean isLocaleAware();

    protected abstract String apply(String var1, Locale var2);

    @Nonnull
    protected abstract String getRuleBuilderName();

    @Nonnull
    protected abstract String getRuleBuilderTitle();
}

