/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.pipelineprocessor.functions.strings.StringUtilsFunction;

public class Uncapitalize
extends StringUtilsFunction {
    public static final String NAME = "uncapitalize";

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected String description() {
        return "Uncapitalizes a String changing the first letter to lower case from title case";
    }

    @Override
    protected boolean isLocaleAware() {
        return false;
    }

    @Override
    protected String apply(String value, Locale unused) {
        return StringUtils.uncapitalize((String)value);
    }

    @Override
    @Nonnull
    protected String getRuleBuilderName() {
        return "Uncapitalize string";
    }

    @Override
    @Nonnull
    protected String getRuleBuilderTitle() {
        return "Uncapitalize '${value}' by changing the first letter to lower case";
    }
}

