/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.pipelineprocessor.functions.strings.StringUtilsFunction;

public class Uppercase
extends StringUtilsFunction {
    public static final String NAME = "uppercase";

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected String description() {
        return "Uppercases a string";
    }

    @Override
    protected boolean isLocaleAware() {
        return true;
    }

    @Override
    protected String apply(String value, Locale locale) {
        return StringUtils.upperCase((String)value, (Locale)locale);
    }

    @Override
    @Nonnull
    protected String getRuleBuilderName() {
        return "Upper case string";
    }

    @Override
    @Nonnull
    protected String getRuleBuilderTitle() {
        return "Convert '${value}' to upper case";
    }
}

