/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.syslog;

import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.syslog.SyslogPriorityAsString;
import org.graylog.plugins.pipelineprocessor.functions.syslog.SyslogUtils;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class SyslogPriorityToStringConversion
extends AbstractFunction<SyslogPriorityAsString> {
    public static final String NAME = "expand_syslog_priority_as_string";
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.object("value").description("Value to convert").build();

    @Override
    public SyslogPriorityAsString evaluate(FunctionArgs args, EvaluationContext context) {
        String s = String.valueOf(this.valueParam.required(args, context));
        int priority = Integer.parseInt(s);
        int facility = SyslogUtils.facilityFromPriority(priority);
        String facilityString = SyslogUtils.facilityToString(facility);
        int level = SyslogUtils.levelFromPriority(priority);
        String levelString = SyslogUtils.levelToString(level);
        return SyslogPriorityAsString.create(levelString, facilityString);
    }

    @Override
    public FunctionDescriptor<SyslogPriorityAsString> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(SyslogPriorityAsString.class).params(this.valueParam).description("Converts a syslog priority number to its level and facility string representations").ruleBuilderEnabled().ruleBuilderName("Convert syslog facility").ruleBuilderTitle("Converts a syslog priority number in '${value}' to level and facility string").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.SYSLOG).build();
    }
}

