/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.syslog;

public final class SyslogUtils {
    public static String levelToString(int level) {
        switch (level) {
            case 0: {
                return "Emergency";
            }
            case 1: {
                return "Alert";
            }
            case 2: {
                return "Critical";
            }
            case 3: {
                return "Error";
            }
            case 4: {
                return "Warning";
            }
            case 5: {
                return "Notice";
            }
            case 6: {
                return "Informational";
            }
            case 7: {
                return "Debug";
            }
        }
        return "Unknown";
    }

    public static String facilityToString(int facility) {
        switch (facility) {
            case 0: {
                return "kern";
            }
            case 1: {
                return "user";
            }
            case 2: {
                return "mail";
            }
            case 3: {
                return "daemon";
            }
            case 4: {
                return "auth";
            }
            case 5: {
                return "syslog";
            }
            case 6: {
                return "lpr";
            }
            case 7: {
                return "news";
            }
            case 8: {
                return "uucp";
            }
            case 9: {
                return "clock";
            }
            case 10: {
                return "authpriv";
            }
            case 11: {
                return "ftp";
            }
            case 12: {
                return "ntp";
            }
            case 13: {
                return "log audit";
            }
            case 14: {
                return "log alert";
            }
            case 15: {
                return "cron";
            }
            case 16: {
                return "local0";
            }
            case 17: {
                return "local1";
            }
            case 18: {
                return "local2";
            }
            case 19: {
                return "local3";
            }
            case 20: {
                return "local4";
            }
            case 21: {
                return "local5";
            }
            case 22: {
                return "local6";
            }
            case 23: {
                return "local7";
            }
        }
        return "Unknown";
    }

    public static int levelFromPriority(int priority) {
        return priority - (SyslogUtils.facilityFromPriority(priority) << 3);
    }

    public static int facilityFromPriority(int priority) {
        return priority >> 3;
    }
}

