/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.parser.validation;

import io.jsonwebtoken.lang.Collections;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog.plugins.pipelineprocessor.parser.ParseException;
import org.graylog.plugins.pipelineprocessor.parser.PipelineRuleParser;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilder;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderStep;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.RuleBuilderService;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.validation.ValidationResult;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.validation.Validator;
import org.graylog.plugins.pipelineprocessor.rulebuilder.rest.RuleBuilderDto;

public class ValidatorService {
    private final Set<Validator> conditionValidators;
    private final Set<Validator> actionValidators;
    private final PipelineRuleParser pipelineRuleParser;
    private final RuleBuilderService ruleBuilderService;

    @Inject
    public ValidatorService(@Named(value="conditionValidators") Set<Validator> conditionValidators, @Named(value="actionValidators") Set<Validator> actionValidators, PipelineRuleParser pipelineRuleParser, RuleBuilderService ruleBuilderService) {
        this.conditionValidators = conditionValidators;
        this.actionValidators = actionValidators;
        this.pipelineRuleParser = pipelineRuleParser;
        this.ruleBuilderService = ruleBuilderService;
    }

    public RuleBuilderDto validate(RuleBuilderDto ruleBuilderDto) {
        String source;
        RuleBuilder.Builder validationBuilder;
        block2: {
            RuleBuilder ruleBuilder = ruleBuilderDto.ruleBuilder();
            validationBuilder = ruleBuilder.toBuilder();
            List<RuleBuilderStep> validatedActions = this.validateWithResults(ruleBuilder.actions(), this.actionValidators);
            validationBuilder.actions(validatedActions);
            List<RuleBuilderStep> validatedConditions = this.validateWithResults(ruleBuilder.conditions(), this.conditionValidators);
            validationBuilder.conditions(validatedConditions);
            source = null;
            try {
                validationBuilder.errors(null);
                source = this.parseRule(ruleBuilderDto, validationBuilder.build());
            }
            catch (Exception exception) {
                if (!validatedConditions.stream().allMatch(step -> Collections.isEmpty(step.errors())) || !validatedActions.stream().allMatch(step -> Collections.isEmpty(step.errors()))) break block2;
                validationBuilder.errors(List.of(exception.getMessage()));
            }
        }
        RuleBuilder validatedRuleBuilder = validationBuilder.build();
        return ruleBuilderDto.toBuilder().ruleBuilder(validatedRuleBuilder).source(source).build();
    }

    private String parseRule(RuleBuilderDto ruleBuilderDto, RuleBuilder validatedRuleBuilder) throws ParseException {
        String source = this.ruleBuilderService.generateRuleSource(ruleBuilderDto.title(), validatedRuleBuilder, false);
        this.pipelineRuleParser.parseRule(source, true);
        return source;
    }

    public void validateAndFailFast(RuleBuilderDto ruleBuilderDto) throws IllegalArgumentException, ParseException {
        RuleBuilder ruleBuilder = ruleBuilderDto.ruleBuilder();
        this.validateAndFail(ruleBuilder.actions(), this.actionValidators);
        this.validateAndFail(ruleBuilder.conditions(), this.conditionValidators);
        this.parseRule(ruleBuilderDto, ruleBuilder);
    }

    private void validateAndFail(List<RuleBuilderStep> steps, Set<Validator> validators) {
        if (Objects.nonNull(steps)) {
            steps.forEach(ruleBuilderStep -> {
                for (Validator actionValidator : validators) {
                    ValidationResult result = actionValidator.validate((RuleBuilderStep)ruleBuilderStep);
                    if (!result.failed()) continue;
                    throw new IllegalArgumentException("Validation failed: " + result.failureReason());
                }
            });
        }
    }

    private List<RuleBuilderStep> validateWithResults(List<RuleBuilderStep> actionSteps, Set<Validator> validators) {
        ArrayList<RuleBuilderStep> validatedSteps = new ArrayList<RuleBuilderStep>();
        if (Objects.nonNull(actionSteps)) {
            actionSteps.forEach(ruleBuilderStep -> {
                ArrayList<String> errors = new ArrayList<String>();
                for (Validator actionValidator : validators) {
                    ValidationResult result = actionValidator.validate((RuleBuilderStep)ruleBuilderStep);
                    if (!result.failed()) continue;
                    errors.add(result.failureReason());
                }
                ruleBuilderStep = ruleBuilderStep.toBuilder().errors(errors).build();
                validatedSteps.add((RuleBuilderStep)ruleBuilderStep);
            });
        }
        return validatedSteps;
    }
}

