/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.periodical;

import javax.inject.Inject;
import org.graylog.plugins.sidecar.services.ImportService;
import org.graylog2.plugin.periodical.Periodical;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgeExpiredConfigurationUploads
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeExpiredConfigurationUploads.class);
    private final ImportService importService;

    @Inject
    public PurgeExpiredConfigurationUploads(ImportService importService) {
        this.importService = importService;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean leaderOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 600;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void doRun() {
        Period outOfUseThreshold = new Period().withDays(30);
        int purgedUploads = this.importService.destroyExpired(outOfUseThreshold);
        LOG.debug("Purged {} outdated configuration uploads.", (Object)purgedUploads);
    }
}

