/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.rest.resources;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.sidecar.filter.ActiveSidecarFilter;
import org.graylog.plugins.sidecar.mapper.SidecarStatusMapper;
import org.graylog.plugins.sidecar.rest.models.CollectorAction;
import org.graylog.plugins.sidecar.rest.models.CollectorActions;
import org.graylog.plugins.sidecar.rest.models.NodeConfiguration;
import org.graylog.plugins.sidecar.rest.models.Sidecar;
import org.graylog.plugins.sidecar.rest.models.SidecarRegistrationConfiguration;
import org.graylog.plugins.sidecar.rest.models.SidecarSummary;
import org.graylog.plugins.sidecar.rest.requests.ConfigurationAssignment;
import org.graylog.plugins.sidecar.rest.requests.NodeConfigurationRequest;
import org.graylog.plugins.sidecar.rest.requests.RegistrationRequest;
import org.graylog.plugins.sidecar.rest.responses.RegistrationResponse;
import org.graylog.plugins.sidecar.rest.responses.SidecarListResponse;
import org.graylog.plugins.sidecar.services.ActionService;
import org.graylog.plugins.sidecar.services.EtagService;
import org.graylog.plugins.sidecar.services.SidecarService;
import org.graylog.plugins.sidecar.system.SidecarConfiguration;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Api(value="Sidecar", description="Manage Sidecar fleet", tags={"cloud"})
@Path(value="/sidecars")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RequiresAuthentication
public class SidecarResource
extends RestResource
implements PluginRestResource {
    protected static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("_id", SearchQueryField.Type.OBJECT_ID)).put((Object)"node_id", (Object)SearchQueryField.create("node_id")).put((Object)"name", (Object)SearchQueryField.create("node_name")).put((Object)"sidecar_version", (Object)SearchQueryField.create("sidecar_version")).put((Object)"last_seen", (Object)SearchQueryField.create("last_seen", SearchQueryField.Type.DATE)).put((Object)"operating_system", (Object)SearchQueryField.create("node_details.operating_system")).put((Object)"status", (Object)SearchQueryField.create("node_details.status.status", SearchQueryField.Type.INT)).build();
    private final SidecarService sidecarService;
    private final ActionService actionService;
    private final EtagService etagService;
    private final ActiveSidecarFilter activeSidecarFilter;
    private final SearchQueryParser searchQueryParser;
    private final SidecarStatusMapper sidecarStatusMapper;
    private final SidecarConfiguration sidecarConfiguration;

    @Inject
    public SidecarResource(SidecarService sidecarService, ActionService actionService, ClusterConfigService clusterConfigService, SidecarStatusMapper sidecarStatusMapper, EtagService etagService) {
        this.sidecarService = sidecarService;
        this.sidecarConfiguration = clusterConfigService.getOrDefault(SidecarConfiguration.class, SidecarConfiguration.defaultConfiguration());
        this.actionService = actionService;
        this.activeSidecarFilter = new ActiveSidecarFilter(this.sidecarConfiguration.sidecarInactiveThreshold());
        this.sidecarStatusMapper = sidecarStatusMapper;
        this.etagService = etagService;
        this.searchQueryParser = new SearchQueryParser("node_name", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @GET
    @Timed
    @Path(value="/all")
    @ApiOperation(value="Lists all existing Sidecar registrations")
    @RequiresPermissions(value={"sidecars:read"})
    public SidecarListResponse all() {
        List<Sidecar> sidecars = this.sidecarService.all();
        List<SidecarSummary> sidecarSummaries = this.sidecarService.toSummaryList(sidecars, this.activeSidecarFilter);
        return SidecarListResponse.create("", PaginatedList.PaginationInfo.create(sidecarSummaries.size(), sidecarSummaries.size(), 1, sidecarSummaries.size()), sidecarSummaries.size(), false, null, null, sidecarSummaries);
    }

    @GET
    @Timed
    @ApiOperation(value="Lists existing Sidecar registrations using pagination")
    @RequiresPermissions(value={"sidecars:read"})
    public SidecarListResponse sidecars(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="title,description,name,id") @DefaultValue(value="node_name") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order, @ApiParam(name="only_active") @QueryParam(value="only_active") @DefaultValue(value="false") boolean onlyActive) {
        SearchQuery searchQuery;
        String mappedQuery = this.sidecarStatusMapper.replaceStringStatusSearchQuery(query);
        try {
            searchQuery = this.searchQueryParser.parse(mappedQuery);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid argument in search query: " + e.getMessage());
        }
        PaginatedList<Sidecar> sidecars = onlyActive ? this.sidecarService.findPaginated(searchQuery, this.activeSidecarFilter, page, perPage, sort, order) : this.sidecarService.findPaginated(searchQuery, page, perPage, sort, order);
        List<SidecarSummary> collectorSummaries = this.sidecarService.toSummaryList((List<Sidecar>)((Object)sidecars), this.activeSidecarFilter);
        long total = this.sidecarService.count();
        return SidecarListResponse.create(query, sidecars.pagination(), total, onlyActive, sort, order, collectorSummaries);
    }

    @GET
    @Timed
    @Path(value="/{sidecarId}")
    @ApiOperation(value="Returns at most one Sidecar summary for the specified id")
    @ApiResponses(value={@ApiResponse(code=404, message="No Sidecar with the specified id exists")})
    @RequiresPermissions(value={"sidecars:read"})
    public SidecarSummary get(@ApiParam(name="sidecarId", required=true) @PathParam(value="sidecarId") @NotEmpty String sidecarId) {
        Sidecar sidecar = this.sidecarService.findByNodeId(sidecarId);
        if (sidecar == null) {
            throw new NotFoundException("Could not find sidecar <" + sidecarId + ">");
        }
        return sidecar.toSummary(this.activeSidecarFilter);
    }

    @PUT
    @Timed
    @Path(value="/{sidecarId}")
    @ApiOperation(value="Create/update a Sidecar registration", notes="This is a stateless method which upserts a Sidecar registration")
    @ApiResponses(value={@ApiResponse(code=400, message="The supplied request is not valid.")})
    @RequiresPermissions(value={"sidecars:update"})
    @NoAuditEvent(value="this is only a ping from Sidecars, and would overflow the audit log")
    public Response register(@ApiParam(name="sidecarId", value="The id this Sidecar is registering as.", required=true) @PathParam(value="sidecarId") @NotEmpty String nodeId, @ApiParam(name="JSON body", required=true) @Valid @NotNull RegistrationRequest request, @HeaderParam(value="If-None-Match") String ifNoneMatch, @HeaderParam(value="X-Graylog-Sidecar-Version") @NotEmpty String sidecarVersion) throws JsonProcessingException {
        Sidecar oldSidecar = this.sidecarService.findByNodeId(nodeId);
        Sidecar sidecar = oldSidecar != null ? oldSidecar.toBuilder().nodeName(request.nodeName()).nodeDetails(request.nodeDetails()).sidecarVersion(sidecarVersion).lastSeen(DateTime.now((DateTimeZone)DateTimeZone.UTC)).build() : this.sidecarService.fromRequest(nodeId, request, sidecarVersion);
        if (ifNoneMatch != null) {
            EntityTag etag = new EntityTag(ifNoneMatch.replaceAll("\"", ""));
            if (this.etagService.registrationIsCached(sidecar.nodeId(), etag.toString())) {
                this.sidecarService.save(sidecar);
                return Response.notModified().tag(etag).build();
            }
        }
        Sidecar updated = this.sidecarService.updateTaggedConfigurationAssignments(sidecar);
        this.sidecarService.save(updated);
        sidecar = updated;
        CollectorActions collectorActions = this.actionService.findActionBySidecar(nodeId, true);
        List<CollectorAction> collectorAction = null;
        if (collectorActions != null) {
            collectorAction = collectorActions.action();
        }
        RegistrationResponse sidecarRegistrationResponse = RegistrationResponse.create(SidecarRegistrationConfiguration.create(this.sidecarConfiguration.sidecarUpdateInterval().toStandardDuration().getStandardSeconds(), this.sidecarConfiguration.sidecarSendStatus()), this.sidecarConfiguration.sidecarConfigurationOverride(), collectorAction, sidecar.assignments());
        EntityTag registrationEtag = this.etagService.buildEntityTagForResponse(sidecarRegistrationResponse);
        this.etagService.addSidecarRegistration(sidecar.nodeId(), registrationEtag.toString());
        return Response.accepted((Object)sidecarRegistrationResponse).tag(registrationEtag).build();
    }

    @PUT
    @Timed
    @Path(value="/configurations")
    @ApiOperation(value="Assign configurations to sidecars")
    @RequiresPermissions(value={"sidecars:read", "sidecars:update"})
    @AuditEvent(type="sidecar:sidecar:update")
    public Response assignConfiguration(@ApiParam(name="JSON body", required=true) @Valid @NotNull NodeConfigurationRequest request) throws NotFoundException {
        List nodeIdList = request.nodes().stream().filter(SidecarResource.distinctByKey(NodeConfiguration::nodeId)).map(NodeConfiguration::nodeId).collect(Collectors.toList());
        for (String nodeId : nodeIdList) {
            List<ConfigurationAssignment> nodeRelations = request.nodes().stream().filter(a -> a.nodeId().equals(nodeId)).flatMap(a -> a.assignments().stream()).collect(Collectors.toList());
            try {
                Sidecar sidecar = this.sidecarService.applyManualAssignments(nodeId, nodeRelations);
                this.sidecarService.save(sidecar);
                this.etagService.invalidateRegistration(sidecar.nodeId());
            }
            catch (org.graylog2.database.NotFoundException e) {
                throw new NotFoundException(e.getMessage());
            }
        }
        return Response.accepted().build();
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

