/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.adapters.otx;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import org.graylog.plugins.threatintel.adapters.otx.AutoValue_OTXDataAdapter_Config;
import org.graylog.plugins.threatintel.adapters.otx.OTXDataAdapter;

abstract class $AutoValue_OTXDataAdapter_Config
extends OTXDataAdapter.Config {
    private final String type;
    @NotEmpty
    private final String indicator;
    @Nullable
    private final String apiKey;
    @NotEmpty
    private final String apiUrl;
    @NotEmpty
    private final String httpUserAgent;
    @Min(value=1L)
    private final @Min(value=1L) long httpConnectTimeout;
    @Min(value=1L)
    private final @Min(value=1L) long httpWriteTimeout;
    @Min(value=1L)
    private final @Min(value=1L) long httpReadTimeout;

    $AutoValue_OTXDataAdapter_Config(String type, @NotEmpty String indicator, @Nullable String apiKey, @NotEmpty String apiUrl, @NotEmpty String httpUserAgent, @Min(value=1L) @Min(value=1L) long httpConnectTimeout, @Min(value=1L) @Min(value=1L) long httpWriteTimeout, @Min(value=1L) @Min(value=1L) long httpReadTimeout) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        if (indicator == null) {
            throw new NullPointerException("Null indicator");
        }
        this.indicator = indicator;
        this.apiKey = apiKey;
        if (apiUrl == null) {
            throw new NullPointerException("Null apiUrl");
        }
        this.apiUrl = apiUrl;
        if (httpUserAgent == null) {
            throw new NullPointerException("Null httpUserAgent");
        }
        this.httpUserAgent = httpUserAgent;
        this.httpConnectTimeout = httpConnectTimeout;
        this.httpWriteTimeout = httpWriteTimeout;
        this.httpReadTimeout = httpReadTimeout;
    }

    @Override
    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="indicator")
    @NotEmpty
    public String indicator() {
        return this.indicator;
    }

    @Override
    @JsonProperty(value="api_key")
    @Nullable
    public String apiKey() {
        return this.apiKey;
    }

    @Override
    @JsonProperty(value="api_url")
    @NotEmpty
    public String apiUrl() {
        return this.apiUrl;
    }

    @Override
    @JsonProperty(value="http_user_agent")
    @NotEmpty
    public String httpUserAgent() {
        return this.httpUserAgent;
    }

    @Override
    @JsonProperty(value="http_connect_timeout")
    @Min(value=1L)
    public @Min(value=1L) long httpConnectTimeout() {
        return this.httpConnectTimeout;
    }

    @Override
    @JsonProperty(value="http_write_timeout")
    @Min(value=1L)
    public @Min(value=1L) long httpWriteTimeout() {
        return this.httpWriteTimeout;
    }

    @Override
    @JsonProperty(value="http_read_timeout")
    @Min(value=1L)
    public @Min(value=1L) long httpReadTimeout() {
        return this.httpReadTimeout;
    }

    public String toString() {
        return "Config{type=" + this.type + ", indicator=" + this.indicator + ", apiKey=" + this.apiKey + ", apiUrl=" + this.apiUrl + ", httpUserAgent=" + this.httpUserAgent + ", httpConnectTimeout=" + this.httpConnectTimeout + ", httpWriteTimeout=" + this.httpWriteTimeout + ", httpReadTimeout=" + this.httpReadTimeout + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OTXDataAdapter.Config) {
            OTXDataAdapter.Config that = (OTXDataAdapter.Config)o;
            return this.type.equals(that.type()) && this.indicator.equals(that.indicator()) && (this.apiKey == null ? that.apiKey() == null : this.apiKey.equals(that.apiKey())) && this.apiUrl.equals(that.apiUrl()) && this.httpUserAgent.equals(that.httpUserAgent()) && this.httpConnectTimeout == that.httpConnectTimeout() && this.httpWriteTimeout == that.httpWriteTimeout() && this.httpReadTimeout == that.httpReadTimeout();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.indicator.hashCode();
        h$ *= 1000003;
        h$ ^= this.apiKey == null ? 0 : this.apiKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.apiUrl.hashCode();
        h$ *= 1000003;
        h$ ^= this.httpUserAgent.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.httpConnectTimeout >>> 32 ^ this.httpConnectTimeout);
        h$ *= 1000003;
        h$ ^= (int)(this.httpWriteTimeout >>> 32 ^ this.httpWriteTimeout);
        h$ *= 1000003;
        return h$ ^= (int)(this.httpReadTimeout >>> 32 ^ this.httpReadTimeout);
    }

    @Override
    public OTXDataAdapter.Config.Builder toBuilder() {
        return new Builder(this);
    }

    static class Builder
    extends OTXDataAdapter.Config.Builder {
        private String type;
        @NotEmpty
        private String indicator;
        private String apiKey;
        @NotEmpty
        private String apiUrl;
        @NotEmpty
        private String httpUserAgent;
        @Min(value=1L)
        private @Min(value=1L) long httpConnectTimeout;
        @Min(value=1L)
        private @Min(value=1L) long httpWriteTimeout;
        @Min(value=1L)
        private @Min(value=1L) long httpReadTimeout;
        private byte set$0;

        Builder() {
        }

        private Builder(OTXDataAdapter.Config source) {
            this.type = source.type();
            this.indicator = source.indicator();
            this.apiKey = source.apiKey();
            this.apiUrl = source.apiUrl();
            this.httpUserAgent = source.httpUserAgent();
            this.httpConnectTimeout = source.httpConnectTimeout();
            this.httpWriteTimeout = source.httpWriteTimeout();
            this.httpReadTimeout = source.httpReadTimeout();
            this.set$0 = (byte)7;
        }

        @Override
        public OTXDataAdapter.Config.Builder type(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public OTXDataAdapter.Config.Builder indicator(String indicator) {
            if (indicator == null) {
                throw new NullPointerException("Null indicator");
            }
            this.indicator = indicator;
            return this;
        }

        @Override
        public OTXDataAdapter.Config.Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public OTXDataAdapter.Config.Builder apiUrl(String apiUrl) {
            if (apiUrl == null) {
                throw new NullPointerException("Null apiUrl");
            }
            this.apiUrl = apiUrl;
            return this;
        }

        @Override
        public OTXDataAdapter.Config.Builder httpUserAgent(String httpUserAgent) {
            if (httpUserAgent == null) {
                throw new NullPointerException("Null httpUserAgent");
            }
            this.httpUserAgent = httpUserAgent;
            return this;
        }

        @Override
        public OTXDataAdapter.Config.Builder httpConnectTimeout(long httpConnectTimeout) {
            this.httpConnectTimeout = httpConnectTimeout;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public OTXDataAdapter.Config.Builder httpWriteTimeout(long httpWriteTimeout) {
            this.httpWriteTimeout = httpWriteTimeout;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public OTXDataAdapter.Config.Builder httpReadTimeout(long httpReadTimeout) {
            this.httpReadTimeout = httpReadTimeout;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public OTXDataAdapter.Config build() {
            if (this.set$0 != 7 || this.type == null || this.indicator == null || this.apiUrl == null || this.httpUserAgent == null) {
                StringBuilder missing = new StringBuilder();
                if (this.type == null) {
                    missing.append(" type");
                }
                if (this.indicator == null) {
                    missing.append(" indicator");
                }
                if (this.apiUrl == null) {
                    missing.append(" apiUrl");
                }
                if (this.httpUserAgent == null) {
                    missing.append(" httpUserAgent");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" httpConnectTimeout");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" httpWriteTimeout");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" httpReadTimeout");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_OTXDataAdapter_Config(this.type, this.indicator, this.apiKey, this.apiUrl, this.httpUserAgent, this.httpConnectTimeout, this.httpWriteTimeout, this.httpReadTimeout);
        }
    }
}

