/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.functions;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class GenericLookupResult
extends ForwardingMap<String, Object> {
    public static final String RESULTS_KEY = "threat_indicated";
    private final ImmutableMap<String, Object> results;
    public static final GenericLookupResult FALSE = new FalseGenericLookupResult();
    public static final GenericLookupResult TRUE = new TrueGenericLookupResult();

    private GenericLookupResult(ImmutableMap<String, Object> fields) {
        this.results = fields;
    }

    public Map<String, Object> getResults() {
        return this.results;
    }

    public boolean isMatch() {
        return (Boolean)this.getResults().get(RESULTS_KEY);
    }

    protected Map<String, Object> delegate() {
        return this.getResults();
    }

    private static class FalseGenericLookupResult
    extends GenericLookupResult {
        private static final ImmutableMap<String, Object> FALSE = ImmutableMap.builder().put((Object)"threat_indicated", (Object)false).build();

        private FalseGenericLookupResult() {
            super(FALSE);
        }
    }

    private static class TrueGenericLookupResult
    extends GenericLookupResult {
        private static final ImmutableMap<String, Object> TRUE = ImmutableMap.builder().put((Object)"threat_indicated", (Object)true).build();

        private TrueGenericLookupResult() {
            super(TRUE);
        }
    }
}

