/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.functions.otx;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.graylog2.plugin.lookup.LookupResult;

public class OTXLookupResult
extends ForwardingMap<String, Object> {
    public static final String MESSAGE = "message";
    public static final String HAS_ERROR = "has_error";
    public static final String OTX_THREAT_INDICATED = "otx_threat_indicated";
    private final ImmutableMap<String, Object> results;
    protected static final OTXLookupResult EMPTY = new EmptyOTXLookupResult();
    protected static final OTXLookupResult FALSE = new FalseOTXLookupResult();

    public static OTXLookupResult buildFromError(LookupResult lookupResult) {
        return new FalseOTXLookupResult((String)lookupResult.singleValue());
    }

    public OTXLookupResult(ImmutableMap<String, Object> fields) {
        this.results = fields;
    }

    public Map<String, Object> getResults() {
        return this.results;
    }

    public boolean hasError() {
        if (this.results != null && !this.results.isEmpty()) {
            return this.results.get((Object)HAS_ERROR) != null;
        }
        return false;
    }

    protected Map<String, Object> delegate() {
        return this.getResults();
    }

    private static class FalseOTXLookupResult
    extends OTXLookupResult {
        private static final ImmutableMap<String, Object> EMPTY = ImmutableMap.builder().put((Object)"otx_threat_indicated", (Object)false).build();

        private FalseOTXLookupResult() {
            super(EMPTY);
        }

        private FalseOTXLookupResult(String errMsg) {
            super((ImmutableMap<String, Object>)ImmutableMap.builder().put((Object)OTXLookupResult.OTX_THREAT_INDICATED, (Object)false).put((Object)OTXLookupResult.HAS_ERROR, (Object)true).put((Object)OTXLookupResult.MESSAGE, (Object)errMsg).build());
        }
    }

    private static class EmptyOTXLookupResult
    extends OTXLookupResult {
        private static final ImmutableMap<String, Object> EMPTY = ImmutableMap.builder().build();

        private EmptyOTXLookupResult() {
            super(EMPTY);
        }
    }
}

