/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.favorites;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import javax.inject.Inject;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.favorites.Favorite;
import org.graylog.plugins.views.favorites.FavoritesService;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.rest.models.PaginatedResponse;

@Api(value="Favorites", tags={"cloud"})
@Path(value="/favorites")
@Produces(value={"application/json"})
@RequiresAuthentication
public class FavoritesResource {
    private final FavoritesService favoritesService;

    @Inject
    public FavoritesResource(FavoritesService favoritesService) {
        this.favoritesService = favoritesService;
    }

    @GET
    @ApiOperation(value="Get the Favorites for the Start Page for the user")
    public PaginatedResponse<Favorite> getFavoriteItems(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="5") int perPage, @ApiParam(name="type") @QueryParam(value="type") Optional<String> type, @Context SearchUser searchUser) {
        return this.favoritesService.findFavoritesFor(searchUser, type, page, perPage);
    }

    @PUT
    @Path(value="/{grn}")
    @ApiOperation(value="Add an item for inclusion on the Start Page for the user")
    @AuditEvent(type="views:dynamic_startup_page:addFavoriteItem")
    public void addItemToFavorites(@ApiParam(name="grn", required=true) @PathParam(value="grn") @NotEmpty String grn, @Context SearchUser searchUser) {
        this.favoritesService.addFavoriteItemFor(grn, searchUser);
    }

    @DELETE
    @Path(value="/{grn}")
    @ApiOperation(value="Remove an item from inclusion on the Start Page for the user")
    @AuditEvent(type="views:dynamic_startup_page:removeFavoriteItem")
    public void removeItemFromFavorites(@ApiParam(name="grn", required=true) @PathParam(value="grn") @NotEmpty String grn, @Context SearchUser searchUser) {
        this.favoritesService.removeFavoriteItemFor(grn, searchUser);
    }
}

